/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preferences.SymbolDefinitionsImportWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SymbolDefinitionsImportWizard
extends Wizard {
    private Display display = null;
    private String importDirectory = null;
    private SymbolDefinitionsImportWizardPage wizardPage;

    public SymbolDefinitionsImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MTJUIMessages.SymbolDefinitionsImportWizardPage_title);
    }

    public void addPages() {
        this.wizardPage = new SymbolDefinitionsImportWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
        this.display = this.getShell().getDisplay();
    }

    public boolean performFinish() {
        switch (this.wizardPage.getImportType()) {
            case 0: {
                try {
                    this.getContainer().run(true, true, this.getProcessImportFromAntennaJarFile());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                this.importDirectory = this.wizardPage.getDirectory();
                try {
                    this.getContainer().run(true, true, this.getProcessImportFromXMLFiles());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return true;
    }

    private IRunnableWithProgress getProcessImportFromAntennaJarFile() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    IPreferenceStore preferenceStore = MTJUIPlugin.getDefault().getCorePreferenceStore();
                    String antennaFile = preferenceStore.getString("antenna_jar");
                    List ss = MTJCore.getSymbolSetFactory().createSymbolSetFromDataBase("org.eclipse.mtj.davicedb.j2mepolish.antennajar", (IPath)new Path(antennaFile), monitor);
                    MTJCore.getSymbolSetRegistry().addSymbolSet(ss);
                }
                catch (IOException e) {
                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, e);
                }
                catch (PersistenceException e) {
                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, e);
                }
            }
        };
    }

    private IRunnableWithProgress getProcessImportFromXMLFiles() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    List ss = MTJCore.getSymbolSetFactory().createSymbolSetFromDataBase("org.eclipse.mtj.davicedb.j2mepolish.file", (IPath)new Path(SymbolDefinitionsImportWizard.this.importDirectory), monitor);
                    MTJCore.getSymbolSetRegistry().addSymbolSet(ss);
                }
                catch (IOException e) {
                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, e);
                }
                catch (PersistenceException e) {
                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, e);
                }
            }
        };
    }

    private void handleException(final String message, Throwable t) {
        t.printStackTrace();
        MTJLogger.log((int)2, (String)message, (Throwable)t);
        this.display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)SymbolDefinitionsImportWizard.this.getShell(), (String)MTJUIMessages.SymbolDefinitionsImportWizardPage_error, (String)message);
            }
        });
    }
}

