/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SymbolDefinitionsImportWizardPage
extends WizardPage {
    public static final int IMPORT_FROM_ANTENNA_JAR = 0;
    public static final int IMPORT_J2MEPOLISH_FORMAT = 1;
    public static final int IMPORT_MTJ_FORMAT = 2;
    public static final String NAME = "symbolDefinitionsImportPage";
    private static final String KEY_WIDTH = "dialogWidth";
    private static final String KEY_HEIGHT = "dialogHeight";
    private Button[] importTypeRadios;
    private Label importFileLabel;
    private Text importDirectory;
    private Button importFileBrowseButton;
    private String antennaFile;

    public SymbolDefinitionsImportWizardPage() {
        super(NAME, MTJUIMessages.SymbolDefinitionsImportWizardPage_title, null);
        this.setPageComplete(true);
        this.setDescription(MTJUIMessages.SymbolDefinitionsImportWizardPage_description);
    }

    private void addChooseFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.importFileLabel = new Label(composite, 0);
        this.importFileLabel.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_specifyDirectory);
        this.importDirectory = new Text(composite, 2048);
        this.importDirectory.setLayoutData((Object)new GridData(768));
        this.importDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SymbolDefinitionsImportWizardPage.this.updateFinishButton();
            }
        });
        this.importFileBrowseButton = new Button(composite, 8);
        this.importFileBrowseButton.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_browse);
        this.importFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsImportWizardPage.this.handleBrowseButton();
            }
        });
    }

    private void addImportSelectorControls(Composite parent) {
        Group importTypeGroup = new Group(parent, 0);
        importTypeGroup.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_from);
        importTypeGroup.setLayout((Layout)new GridLayout(1, false));
        importTypeGroup.setLayoutData((Object)new GridData(768));
        this.importTypeRadios = new Button[2];
        this.importTypeRadios[0] = new Button((Composite)importTypeGroup, 16);
        this.importTypeRadios[0].setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_importFromAntennaJarFile);
        this.importTypeRadios[1] = new Button((Composite)importTypeGroup, 16);
        this.importTypeRadios[1].setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_importFromXMLFiles);
        this.importTypeRadios[0].setSelection(true);
        this.importTypeRadios[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    SymbolDefinitionsImportWizardPage.this.updateControlEnable(true);
                } else {
                    SymbolDefinitionsImportWizardPage.this.updateControlEnable(false);
                }
                SymbolDefinitionsImportWizardPage.this.updateFinishButton();
            }
        });
        this.addChooseFileControl((Composite)importTypeGroup);
        this.updateControlEnable(false);
        this.updateFinishButton();
    }

    public void createControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SymbolDefinitionsImportWizardPage.this.storeSize();
            }
        });
        this.setControl((Control)composite);
        IPreferenceStore preferenceStore = MTJUIPlugin.getDefault().getCorePreferenceStore();
        this.antennaFile = preferenceStore.getString("antenna_jar");
        this.addImportSelectorControls(composite);
        Point size = this.retrieveSize();
        if (size != null) {
            composite.setSize(size);
        }
    }

    public String getDirectory() {
        return this.importDirectory.getText();
    }

    public int getImportType() {
        if (this.importTypeRadios[0].getSelection()) {
            return 0;
        }
        if (this.importTypeRadios[1].getSelection()) {
            return 1;
        }
        return 2;
    }

    private void handleBrowseButton() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String directory = dialog.open();
        if (directory != null) {
            this.importDirectory.setText(directory);
            this.updateFinishButton();
        }
    }

    private Point retrieveSize() {
        Point size = null;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && settings.get(KEY_WIDTH) != null) {
            size = new Point(settings.getInt(KEY_WIDTH), settings.getInt(KEY_HEIGHT));
        }
        return size;
    }

    private void storeSize() {
        IDialogSettings settings = this.getDialogSettings();
        Point size = this.getControl().getSize();
        if (settings != null) {
            settings.put(KEY_WIDTH, size.x);
            settings.put(KEY_HEIGHT, size.y);
        }
    }

    private void updateControlEnable(boolean value) {
        this.importFileLabel.setEnabled(value);
        this.importFileBrowseButton.setEnabled(value);
        this.importDirectory.setEnabled(value);
    }

    public void updateFinishButton() {
        String directory;
        if (this.importTypeRadios[0].getSelection()) {
            if (!new File(this.antennaFile).exists()) {
                this.setPageComplete(false);
                this.setErrorMessage(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_antennaLibraryIsNotSpecified);
                return;
            }
        } else if (!(!this.importTypeRadios[1].getSelection() || new File(String.valueOf(directory = this.importDirectory.getText().trim()) + File.separator + "devices.xml").exists() && new File(String.valueOf(directory) + File.separator + "groups.xml").exists())) {
            this.setPageComplete(false);
            this.setErrorMessage(NLS.bind((String)MTJUIMessages.SymbolDefinitionsImportWizardPage_error_directoryDoesNotContaintFiles, (Object[])new Object[]{"devices.xml", "groups.xml"}));
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

