/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.AntennaPPDirectiveProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.AntennaPPPrefixHandler;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessDirectiveProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessPrefixHandler;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDebugLevel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDirective;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.ProposalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessContext {
    private static final IPreprocessPrefixHandler DEFAULT_PREFIX_HANDLER = new AntennaPPPrefixHandler();
    private static final IPreprocessDirectiveProvider DEFAULT_DIRECTIVE_PROVIDER = new AntennaPPDirectiveProvider();
    public static final char COMMON_SEPARATOR = ' ';
    private static final int STATAMENT_DIRECTIVE_UNCOMPLETE = 0;
    private static final int STATAMENT_DIRECTIVE_COMPLETE = 1;
    private IPreprocessPrefixHandler prefixHandler = DEFAULT_PREFIX_HANDLER;
    private IPreprocessDirectiveProvider directiveProvider = DEFAULT_DIRECTIVE_PROVIDER;
    private IDocument document;
    private int fOffset;
    private IProject containedProject;
    private boolean validEnv = false;
    private int fLineStartOffset = -1;
    private int fStatementStartOffset = -1;
    private int fCompletionOffset = -1;
    private int currStatementState;

    public PreprocessContext(IDocument document, int offset, IProject containedProject) {
        this.document = document;
        this.fOffset = offset;
        this.containedProject = containedProject;
        this.initialize();
    }

    public boolean accept(PreprocessDebugLevel dLevel) {
        return this.prefixMatch(dLevel);
    }

    public boolean accept(PreprocessDirective directive) {
        if (!this.prefixMatch(directive)) {
            return false;
        }
        return this.sytaxAcceptable(directive);
    }

    public boolean accept(PreprocessSymbol symbol) {
        return this.prefixMatch(symbol);
    }

    private boolean sytaxAcceptable(PreprocessDirective directive) {
        if (directive.getName().equalsIgnoreCase("condition")) {
            try {
                int lineNum = this.document.getLineOfOffset(this.fOffset);
                if (lineNum != 0) {
                    return false;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return true;
    }

    public int getCompletionOffset() {
        if (this.fCompletionOffset == -1) {
            if (this.currStatementState == 0) {
                this.fCompletionOffset = this.getStatementStartOffset();
            } else if (this.currStatementState == 1) {
                this.fCompletionOffset = this.getWordBeginingPos(' ');
            }
        }
        return this.fCompletionOffset;
    }

    public IProject getContainedProject() {
        return this.containedProject;
    }

    private String getCurrDirectiveName() {
        String statement = this.getPreprocessStatement();
        String directiveName = statement.substring(0, statement.indexOf(32));
        return directiveName;
    }

    public IPreprocessDirectiveProvider getDirectiveProvider() {
        return this.directiveProvider;
    }

    public IDocument getDocument() {
        return this.document;
    }

    private String getDocumentSegment(int startPos, int length) {
        String value = "";
        try {
            value = this.document.get(startPos, length);
        }
        catch (BadLocationException badLocationException) {}
        return value;
    }

    public int getLineStartOffset() {
        if (this.fLineStartOffset == -1) {
            try {
                int lineNum = this.document.getLineOfOffset(this.fOffset);
                this.fLineStartOffset = this.document.getLineOffset(lineNum);
            }
            catch (BadLocationException badLocationException) {
                this.fLineStartOffset = 0;
            }
        }
        return this.fLineStartOffset;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public List<ProposalType> getPossibleProposalTypes() {
        ArrayList<ProposalType> types = new ArrayList<ProposalType>();
        if (!this.validEnv) {
            return types;
        }
        if (this.currStatementState == 0) {
            types.add(ProposalType.TEMPLATE);
            types.add(ProposalType.DIRECTIVE);
            return types;
        }
        if (this.currStatementState == 1 && this.hasLegalDirective()) {
            if (this.needSymbolProposal()) {
                types.add(ProposalType.SYMBOL);
                return types;
            }
            if (this.needDebugLevelProposal()) {
                types.add(ProposalType.DEBUG_LEVER);
                return types;
            }
        }
        return types;
    }

    public String getPreprocessingLine() {
        int start = this.getLineStartOffset();
        int length = this.getOffset() - start;
        return this.getDocumentSegment(start, length);
    }

    public String getPreprocessingLinePrefix() {
        return this.prefixHandler.getCurrPrefix(this.getPreprocessingLine());
    }

    public String getPreprocessStatement() {
        int start = this.getStatementStartOffset();
        int length = this.getOffset() - start;
        return this.getDocumentSegment(start, length);
    }

    public int getStatementStartOffset() {
        if (this.fStatementStartOffset == -1) {
            this.fStatementStartOffset = this.getLineStartOffset() + this.getPreprocessingLinePrefix().length();
        }
        return this.fStatementStartOffset;
    }

    private String getUncompletedElementName() {
        int elementBeginPos = this.getCompletionOffset();
        String unCompleteElementName = "";
        try {
            unCompleteElementName = this.document.get(elementBeginPos, this.getOffset() - elementBeginPos);
        }
        catch (BadLocationException badLocationException) {}
        return unCompleteElementName;
    }

    private int getWordBeginingPos(char seperator) {
        int wordBeginPos = this.getOffset();
        try {
            while (this.document.getChar(wordBeginPos) != seperator) {
                --wordBeginPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return wordBeginPos + 1;
    }

    private boolean hasLegalDirective() {
        return this.isLegalDirective(this.getCurrDirectiveName());
    }

    private void initialize() {
        String statement;
        this.validEnv = this.validatePPEnvironment();
        if (this.validEnv && (statement = this.getPreprocessStatement()).indexOf(32) >= 0) {
            this.currStatementState = 1;
        }
    }

    private boolean isInRightProject(IProject project) {
        boolean preprocessing = false;
        try {
            preprocessing = project.hasNature("org.eclipse.mtj.core.preprocessingNature");
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (Throwable)e);
        }
        return preprocessing;
    }

    private boolean isLegalDirective(String directiveName) {
        if (this.getDirectiveProvider() != null) {
            return this.getDirectiveProvider().getDirective(directiveName) != null;
        }
        return false;
    }

    private boolean needDebugLevelProposal() {
        String directiveName = this.getCurrDirectiveName();
        return directiveName.equalsIgnoreCase("debug") || directiveName.equalsIgnoreCase("mdebug");
    }

    private boolean needSymbolProposal() {
        String directiveName = this.getCurrDirectiveName();
        return !directiveName.equalsIgnoreCase("else") && !directiveName.equalsIgnoreCase("debug") && !directiveName.equalsIgnoreCase("mdebug") && !directiveName.equalsIgnoreCase("endif") && !directiveName.equalsIgnoreCase("enddebug");
    }

    private boolean prefixMatch(IPreprocessContentAssistModel model) {
        String unCompleteSymbolName = this.getUncompletedElementName();
        return model.getName().regionMatches(true, 0, unCompleteSymbolName, 0, unCompleteSymbolName.length());
    }

    public void setDirectiveProvider(IPreprocessDirectiveProvider directiveProvider) {
        this.directiveProvider = directiveProvider;
    }

    public void setPrefixHandler(IPreprocessPrefixHandler prefixHandler) {
        this.prefixHandler = prefixHandler;
    }

    private boolean validatePPEnvironment() {
        return this.isInRightProject(this.containedProject) && this.prefixHandler.hasLegalPrefix(this.getPreprocessingLine());
    }
}

