/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDirective;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbolProviderInfo;

public class PreprocessJavaDocProvider {
    private static PreprocessJavaDocProvider fDefault;
    private static final String NEW_LINE_HTML = "<BR>";

    public static PreprocessJavaDocProvider getDefault() {
        if (fDefault == null) {
            fDefault = new PreprocessJavaDocProvider();
        }
        return fDefault;
    }

    private PreprocessJavaDocProvider() {
    }

    private String getDirectiveDocKey(PreprocessDirective directive) {
        return String.valueOf(directive.getName()) + "_javadoc";
    }

    public String getDirectiveJavaDoc(PreprocessDirective directive) {
        String key = this.getDirectiveDocKey(directive);
        return PreprocessContentAssistMessages.getString(key);
    }

    public String getSymbolJavaDoc(PreprocessSymbol symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("Followings are the symbol provider's information:<BR><BR>");
        for (PreprocessSymbolProviderInfo provider : symbol.getProviderInfos()) {
            this.showProviderInfo(provider, sb);
            sb.append(NEW_LINE_HTML);
        }
        return sb.toString();
    }

    private void showProviderInfo(PreprocessSymbolProviderInfo provider, StringBuffer sb) {
        if (provider.isActive) {
            sb.append("<B>");
        }
        sb.append("    ");
        sb.append(provider.getProviderName());
        sb.append(" - ");
        sb.append(provider.getProvidedSymbolValue());
        if (provider.isActive) {
            sb.append("</B>");
        }
    }
}

