/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessJavaDocProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbolProviderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessSymbol
implements IPreprocessContentAssistModel {
    private static final int DEFAULTSYMBOLTYPE = 0;
    private String name;
    private int symbolType;
    private List<PreprocessSymbolProviderInfo> providerInfos;

    public PreprocessSymbol(String symbolName) {
        this(symbolName, 0);
    }

    public PreprocessSymbol(String symbolName, int symbolType) {
        this.name = symbolName;
        this.symbolType = symbolType;
    }

    public boolean addProvider(PreprocessSymbolProviderInfo provider) {
        return this.getProviderInfos().add(provider);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreprocessSymbol other = (PreprocessSymbol)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getDescription() {
        if (this.symbolType == 1) {
            return this.getConfigurationSymbolDesc();
        }
        return this.getAbilitySymbolDesc();
    }

    private String getConfigurationSymbolDesc() {
        return PreprocessContentAssistMessages.symbol_configuration;
    }

    private String getAbilitySymbolDesc() {
        StringBuffer sb = new StringBuffer();
        if (this.isActive()) {
            sb.append(PreprocessContentAssistMessages.symbol_active);
        } else {
            sb.append(PreprocessContentAssistMessages.symbol_inactive);
        }
        sb.append("(");
        Iterator<String> it = this.getPossibleValues().iterator();
        while (it.hasNext()) {
            String value = it.next();
            sb.append(value);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getJavaDoc() {
        return PreprocessJavaDocProvider.getDefault().getSymbolJavaDoc(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HashSet<String> getPossibleValues() {
        HashSet<String> values = new HashSet<String>();
        for (PreprocessSymbolProviderInfo provider : this.getProviderInfos()) {
            values.add(provider.getProvidedSymbolValue());
        }
        return values;
    }

    public List<PreprocessSymbolProviderInfo> getProviderInfos() {
        if (this.providerInfos == null) {
            this.providerInfos = new ArrayList<PreprocessSymbolProviderInfo>();
        }
        return this.providerInfos;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isActive() {
        for (PreprocessSymbolProviderInfo provider : this.getProviderInfos()) {
            if (!provider.isActive) continue;
            return true;
        }
        return false;
    }
}

