/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbolProviderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessSymbolManager {
    private static void createSymbol(HashSet<PreprocessSymbol> symbols, String symbolName, int symbolType, String value, String providerName, boolean isActive) {
        PreprocessSymbol symbol = new PreprocessSymbol(symbolName, symbolType);
        PreprocessSymbolProviderInfo provider = new PreprocessSymbolProviderInfo(providerName, value, isActive);
        if (symbols.contains(symbol)) {
            for (PreprocessSymbol aSymbol : symbols) {
                if (!symbol.equals(aSymbol)) continue;
                aSymbol.addProvider(provider);
            }
        } else {
            symbol.addProvider(provider);
            symbols.add(symbol);
        }
    }

    public static List<PreprocessSymbol> getSymbols(IProject project) {
        HashSet<PreprocessSymbol> symbolmap = new HashSet<PreprocessSymbol>();
        IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)JavaCore.create((IProject)project));
        MTJRuntimeList configurations = midletSuite.getRuntimeList();
        for (MTJRuntime configuration : configurations) {
            ISymbolSet symbolSet = configuration.getSymbolSetForPreprocessing();
            boolean isActive = configuration.isActive();
            for (ISymbol symbol : symbolSet.getSymbols()) {
                PreprocessSymbolManager.createSymbol(symbolmap, symbol.getName(), symbol.getType(), symbol.getValue(), configuration.getName(), isActive);
            }
            List workspaceSymbolSets = configuration.getWorkspaceScopeSymbolSets();
            for (ISymbolSet wsymbolset : workspaceSymbolSets) {
                Collection c = wsymbolset.getSymbols();
                for (ISymbol s : c) {
                    String key = s.getName();
                    String value = s.getValue();
                    PreprocessSymbolManager.createSymbol(symbolmap, key, 0, value, wsymbolset.getName(), isActive);
                }
            }
        }
        return new ArrayList<PreprocessSymbol>(symbolmap);
    }
}

