/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateFormatter;

public class PreprocessTemplateContext
extends DocumentTemplateContext {
    int ppDirectiveBeginOffset = 0;
    PreprocessContext ppContext;

    public PreprocessTemplateContext(TemplateContextType type, IDocument document, Position position, PreprocessContext ppContext) {
        super(type, document, position);
        this.ppDirectiveBeginOffset = ppContext.getStatementStartOffset();
        this.ppContext = ppContext;
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer buffer = this.evaluateWithoutFormatter(template);
        if (buffer == null) {
            return null;
        }
        IPreferenceStore prefs = MTJUIPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.mtj.ui.template.format");
        if (useCodeFormatter) {
            IJavaProject project = JavaCore.create((IProject)this.ppContext.getContainedProject());
            PreprocessTemplateFormatter formatter = new PreprocessTemplateFormatter();
            formatter.format(buffer, (TemplateContext)this, project);
        }
        return buffer;
    }

    public TemplateBuffer evaluateWithoutFormatter(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    public String getKey() {
        int offset = this.getPpDirectiveBeginOffset();
        int length = this.getEnd() - offset;
        try {
            return this.getDocument().get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getPpDirectiveBeginOffset() {
        return this.ppDirectiveBeginOffset;
    }
}

