/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateAccess;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContextType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateInformationControlCreator;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessTemplateEngine {
    private static final int DEFAULT_TEMPLATE_PROPOSAL_SERVERITY = 1;
    private PreprocessTemplateContextType ppTemplateContextType;

    public PreprocessTemplateEngine(PreprocessTemplateContextType ppTemplateContextType) {
        this.ppTemplateContextType = ppTemplateContextType;
    }

    public List<PreprocessTemplateProposal> complete(PreprocessContext ppContext) {
        ArrayList<PreprocessTemplateProposal> result = new ArrayList<PreprocessTemplateProposal>();
        Template[] templates = PreprocessTemplateAccess.getDefault().getTemplateStore().getTemplates();
        Position position = this.getReplacePosition(ppContext);
        PreprocessTemplateContext pTemplateContext = this.ppTemplateContextType.createContext(ppContext.getDocument(), position, ppContext);
        Region region = new Region(position.offset, position.length);
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template element = templateArray[n2];
            if (pTemplateContext.canEvaluate(element)) {
                PreprocessTemplateProposal proposal = this.constructTemplateProposal(element, pTemplateContext, (IRegion)region);
                result.add(proposal);
            }
            ++n2;
        }
        return result;
    }

    private PreprocessTemplateProposal constructTemplateProposal(Template template, PreprocessTemplateContext ppTemplateContext, IRegion region) {
        PreprocessTemplateProposal proposal = new PreprocessTemplateProposal(template, (TemplateContext)ppTemplateContext, region, MTJUIPluginImages.DESC_PREPROCESS_TEMPLATE_PROPOSAL.createImage(), 1);
        proposal.setInformationControlCreator(new PreprocessTemplateInformationControlCreator());
        return proposal;
    }

    private Position getReplacePosition(PreprocessContext ppContext) {
        int offset = ppContext.getOffset();
        IDocument doc = ppContext.getDocument();
        int lineStart = ppContext.getLineStartOffset();
        String prefix = "";
        try {
            prefix = doc.get(lineStart, offset - lineStart).trim();
        }
        catch (BadLocationException badLocationException) {}
        Position position = new Position(offset - prefix.length(), prefix.length());
        return position;
    }
}

