/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.ExclusivePositionUpdater;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class VariableTracker {
    private static final String CATEGORY = "__template_variables";
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private Document fDocument;
    private final TemplateBuffer fBuffer;
    private List fPositions;

    public VariableTracker(TemplateBuffer buffer) throws MalformedTreeException, BadLocationException {
        Assert.isLegal((buffer != null ? 1 : 0) != 0);
        this.fBuffer = buffer;
        this.fDocument = new Document(this.fBuffer.getString());
        this.fDocument.addPositionCategory(CATEGORY);
        this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
        this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
    }

    private void checkState() {
        if (this.fDocument == null) {
            throw new IllegalStateException();
        }
    }

    private List createRangeMarkers(TemplateVariable[] variables, IDocument document) throws MalformedTreeException, BadLocationException {
        HashMap<ReplaceEdit, String> markerToOriginal = new HashMap<ReplaceEdit, String>();
        MultiTextEdit root = new MultiTextEdit(0, document.getLength());
        ArrayList<Object> edits = new ArrayList<Object>();
        boolean hasModifications = false;
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] nArray = variable.getOffsets();
            String value = variable.getDefaultValue();
            if (this.isWhitespaceVariable(value)) {
                String placeholder = COMMENT_START + value + COMMENT_END;
                int j = 0;
                while (j != nArray.length) {
                    ReplaceEdit replace = new ReplaceEdit(nArray[j], value.length(), placeholder);
                    root.addChild((TextEdit)replace);
                    hasModifications = true;
                    markerToOriginal.put(replace, value);
                    edits.add(replace);
                    ++j;
                }
            } else {
                int j = 0;
                while (j != nArray.length) {
                    RangeMarker marker = new RangeMarker(nArray[j], value.length());
                    root.addChild((TextEdit)marker);
                    edits.add(marker);
                    ++j;
                }
            }
            ++i;
        }
        if (hasModifications) {
            root.apply(document, 2);
        }
        ArrayList<TypedPosition> positions = new ArrayList<TypedPosition>();
        for (TextEdit textEdit : edits) {
            try {
                TypedPosition pos = new TypedPosition(textEdit.getOffset(), textEdit.getLength(), (String)markerToOriginal.get(textEdit));
                document.addPosition(CATEGORY, (Position)pos);
                positions.add(pos);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
        }
        return positions;
    }

    public IDocument getDocument() {
        this.checkState();
        return this.fDocument;
    }

    private boolean isWhitespaceVariable(String value) {
        int length = value.length();
        return length == 0 || Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1));
    }

    private void removeRangeMarkers(List positions, IDocument document, TemplateVariable[] variables) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
        for (TypedPosition position : positions) {
            document.removePosition(CATEGORY, (Position)position);
            String original = position.getType();
            if (original != null) {
                document.replace(position.getOffset(), position.getLength(), original);
                position.setLength(original.length());
            }
            document.addPosition((Position)position);
        }
        Iterator it = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((Position)it.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
        this.checkState();
        TemplateVariable[] variables = this.fBuffer.getVariables();
        try {
            this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, variables);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            Assert.isTrue((boolean)false);
        }
        this.fBuffer.setContent(this.fDocument.get(), variables);
        this.fDocument = null;
        return this.fBuffer;
    }
}

