/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.Visibility;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.internal.ui.wizards.libraries.LibrarySelectionBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class LibraryPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private List<IClasspathEntry> basicCPEntries = null;
    private boolean dirty = false;
    private IClasspathEntry[] origCPEntries = null;
    private LibrarySelectionBlock selectionBlock = new LibrarySelectionBlock();

    public LibraryPropertyPage() {
        this.basicCPEntries = new ArrayList<IClasspathEntry>();
    }

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    public String getDescription() {
        return MTJUIMessages.LibraryPropertyPage_description;
    }

    public boolean performOk() {
        if (this.selectionBlock != null) {
            final IJavaProject javaProject = JavaCore.create((IProject)this.getCurrentProject());
            final ArrayList newCPEntries = new ArrayList();
            newCPEntries.clear();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                    for (IClasspathEntry entry : LibraryPropertyPage.this.basicCPEntries) {
                        newCPEntries.add(entry);
                    }
                    for (IPath path : LibraryPropertyPage.this.selectionBlock.getSelectedLibrariesPathEntries()) {
                        newCPEntries.add(JavaCore.newContainerEntry((IPath)path, (boolean)true));
                    }
                    javaProject.setRawClasspath(null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    javaProject.setRawClasspath(newCPEntries.toArray(new IClasspathEntry[0]), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                }
            };
            WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), MTJUIMessages.LibraryPropertyPage_error_title, MTJUIMessages.LibraryPropertyPage_error_message);
                try {
                    javaProject.setRawClasspath(this.origCPEntries, null);
                }
                catch (JavaModelException javaModelException) {
                    ExceptionHandler.handle(e, this.getShell(), MTJUIMessages.LibraryPropertyPage_restore_error_title, MTJUIMessages.LibraryPropertyPage_restore_error_message);
                }
                this.initBlockValues();
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        this.dirty = false;
        return true;
    }

    public void setVisible(boolean visible) {
        if (this.selectionBlock != null && !visible && this.dirty) {
            String title = MTJUIMessages.LibraryPropertyPage_unsavedchanges_title;
            String message = MTJUIMessages.LibraryPropertyPage_unsavedchanges_message;
            String[] buttonLabels = new String[]{MTJUIMessages.LibraryPropertyPage_unsavedchanges_button_save, MTJUIMessages.LibraryPropertyPage_unsavedchanges_button_discard, MTJUIMessages.LibraryPropertyPage_unsavedchanges_button_ignore};
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
            int res = dialog.open();
            if (res == 0) {
                this.performOk();
            } else if (res == 1) {
                this.initBlockValues();
            }
        }
        super.setVisible(visible);
    }

    private IProject getCurrentProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        } else if (adaptable instanceof IJavaProject) {
            project = ((IJavaProject)adaptable).getProject();
        }
        return project;
    }

    private void initBlockValues() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getCurrentProject());
        this.basicCPEntries.clear();
        this.selectionBlock.checkAll(false);
        try {
            this.origCPEntries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        if (this.origCPEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = this.origCPEntries;
            int n = this.origCPEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                try {
                    if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("org.eclipse.mtj.core.EXTERNAL_LIBRARY")) {
                        IExternalLibrary library = ExternalLibraryManager.getInstance().getMidletLibrary(entry.getPath().segment(1));
                        if (library != null && library.getVisibility() != Visibility.INVALID) {
                            if (library.getVisibility() != Visibility.INTERNAL) {
                                this.selectionBlock.setChecked(library, true);
                            } else {
                                this.basicCPEntries.add(entry);
                            }
                        }
                    } else {
                        this.basicCPEntries.add(entry);
                    }
                }
                catch (Exception exception) {
                    this.basicCPEntries.add(entry);
                }
                ++n2;
            }
        }
        this.dirty = false;
    }

    protected Control createContents(Composite parent) {
        this.selectionBlock.createControl(parent);
        LibraryAdapter adapter = new LibraryAdapter();
        this.selectionBlock.setLibrarySelectionDialogFieldListener(adapter);
        this.initBlockValues();
        return this.selectionBlock.getControl();
    }

    public class LibraryAdapter
    implements IDialogFieldListener {
        public void dialogFieldChanged(DialogField field) {
            if (LibraryPropertyPage.this.isControlCreated()) {
                LibraryPropertyPage.this.dirty = true;
            }
        }
    }
}

