/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class PropertyAndPreferencePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected PreferencePage preferencePage;
    protected Button projectSpecificSettings;

    public boolean isValid() {
        boolean isValid = true;
        if (this.projectSpecificSettings.getSelection()) {
            isValid = this.preferencePage.isValid();
        }
        return isValid;
    }

    public boolean performCancel() {
        return this.preferencePage.performCancel() && super.performCancel();
    }

    public boolean performOk() {
        this.storeProjectSpecificSettingsValue();
        return this.preferencePage.performOk() && super.performOk();
    }

    private void recursivelySetEnablement(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element2 = controlArray[n2];
                this.recursivelySetEnablement(element2, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }

    private void storeProjectSpecificSettingsValue() {
        this.getPreferenceStore().setValue(this.getProjectSpecificSettingsKey(), this.projectSpecificSettings.getSelection());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mtj.ui.help_J2MEProjectPropertiesPage");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createProjectSpecificControls(composite);
        this.embedPreferencePage(composite);
        this.initializeState();
        return composite;
    }

    protected void createProjectSpecificControls(Composite composite) {
        this.projectSpecificSettings = new Button(composite, 32);
        this.projectSpecificSettings.setText(MTJUIMessages.PropertyAndPreferencePage_projectSpecificSettings_btn_label_text);
        this.projectSpecificSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useProjectSpecificSettings = PropertyAndPreferencePage.this.projectSpecificSettings.getSelection();
                PropertyAndPreferencePage.this.updateEmbeddedEnablement(useProjectSpecificSettings);
                ((IEmbeddableWorkbenchPreferencePage)PropertyAndPreferencePage.this.preferencePage).performDefaults();
            }
        });
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(768));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return MTJUIPlugin.getCoreProjectPreferenceStore(this.getProject());
    }

    protected abstract void embedPreferencePage(Composite var1);

    protected IProject getProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        } else if (adaptable instanceof IJavaProject) {
            project = ((IJavaProject)adaptable).getProject();
        }
        return project;
    }

    protected abstract String getProjectSpecificSettingsKey();

    protected boolean hasProjectSpecificProperties() {
        String key = this.getProjectSpecificSettingsKey();
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(key);
    }

    protected void initializeState() {
        boolean readOnly = this.isReadOnly();
        boolean useProjectSettings = this.hasProjectSpecificProperties();
        this.projectSpecificSettings.setSelection(useProjectSettings);
        this.projectSpecificSettings.setEnabled(!readOnly);
        if (!useProjectSettings || readOnly) {
            this.updateEmbeddedEnablement(false);
        }
    }

    protected boolean isPreprocessedOutputProject() {
        boolean preprocessed = false;
        try {
            preprocessed = this.getProject().hasNature("org.eclipse.mtj.core.preprocessingNature");
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (Throwable)e);
        }
        return preprocessed;
    }

    protected abstract boolean isReadOnly();

    protected void performApply() {
        this.storeProjectSpecificSettingsValue();
        ((IEmbeddableWorkbenchPreferencePage)this.preferencePage).performApply();
    }

    protected void performDefaults() {
        boolean defaultValue = false;
        ((IEmbeddableWorkbenchPreferencePage)this.preferencePage).performDefaults();
        this.projectSpecificSettings.setSelection(defaultValue);
        this.updateEmbeddedEnablement(defaultValue);
    }

    protected void updateEmbeddedEnablement(boolean enabled) {
        this.recursivelySetEnablement(this.preferencePage.getControl(), enabled);
    }
}

