/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.properties;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.J2MENature;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.build.sign.SignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.forms.blocks.SigningBlock;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SigningPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ISignatureProperties sigProps;
    private SigningBlock signingBlock;
    private Text keystoreTxt;
    private Text keystorePasswordTxt;
    private Button ksPasswordBtn3;
    private Button ksPasswordBtn2;
    private Button ksPasswordBtn1;
    private Button passwordBtn;
    private Button externalBtn;
    private Button projectBtn;
    private Text keyPasswordTxt;
    private Button projectSpecificBtn;
    private DefaultKeyStoreManager keyStoreManager;

    public String convertEmptyToNull(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public boolean isValid() {
        boolean result = true;
        if (this.projectSpecificBtn.getSelection()) {
            try {
                String ksPath = this.sigProps.getAbsoluteKeyStorePath(this.getProject());
                result &= ksPath != null && ksPath.length() > 0;
                if (this.sigProps.getPasswordStorageMethod() != 0) {
                    String ksPass = this.keystorePasswordTxt.getText();
                    result &= ksPass != null && ksPass.length() > 0;
                }
            }
            catch (CoreException coreException) {
                result = false;
            }
        }
        return true;
    }

    public boolean performOk() {
        IProject project = this.getProject();
        boolean isJ2meProject = false;
        try {
            isJ2meProject = J2MENature.hasMtjCoreNature((IProject)project);
        }
        catch (CoreException coreException) {}
        if (!isJ2meProject) {
            return true;
        }
        boolean succeeded = false;
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            this.sigProps.setKeyStorePassword(this.keystorePasswordTxt.getText());
            this.sigProps.setKeyPassword(this.keyPasswordTxt.getText());
        }
        this.sigProps.setKeyStoreProvider(this.signingBlock.getProvider());
        this.sigProps.setKeyStoreType(this.signingBlock.getKeystoreType());
        try {
            IMidletSuiteProject midletProject = this.getMidletSuiteProject();
            midletProject.setSignatureProperties(this.sigProps);
            midletProject.saveMetaData();
            succeeded = true;
        }
        catch (CoreException ex) {
            String message = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToSaveSuiteMetadata, (Object)ex.getMessage());
            MTJLogger.log((int)4, (String)message);
        }
        return succeeded;
    }

    private void browseExternalForKeystore() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setText(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        dlg.setFilterNames(IMTJUIConstants.BROWSE_FILTER_NAMES);
        dlg.setFilterExtensions(IMTJUIConstants.BROWSE_FILTER_EXTENSIONS);
        String path = dlg.open();
        if (path == null) {
            return;
        }
        this.resetPasswords();
        this.sigProps.setKeyStoreDisplayPath(path);
        this.keystoreTxt.setText(path);
        this.loadAliases();
    }

    private void resetPasswords() {
        this.keystorePasswordTxt.setEnabled(false);
        this.keystorePasswordTxt.setText("");
        this.keyPasswordTxt.setEnabled(false);
        this.keyPasswordTxt.setText("");
        this.ksPasswordBtn1.setSelection(true);
        this.ksPasswordBtn2.setSelection(false);
        this.ksPasswordBtn3.setSelection(false);
        this.sigProps.setPasswordStorageMethod(0);
        this.sigProps.setKeyStorePassword("");
        this.sigProps.setKeyPassword("");
    }

    private void browseProjectForKeystore() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        dialog.setMessage(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_message);
        dialog.setInput((Object)this.getProject());
        dialog.setAllowMultiple(false);
        dialog.setEmptyListMessage(MTJUIMessages.J2MESigningPropertiesPage_browse_need_file);
        dialog.setStatusLineAboveButtons(true);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, MTJUIMessages.J2MESigningPropertiesPage_browse_need_file, null);
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, MTJUIMessages.J2MESigningPropertiesPage_browse_need_file, null);
                }
                return new Status(0, "org.eclipse.mtj.ui", 0, ((IFile)selection[0]).getName(), null);
            }
        });
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result.length == 0 || !(result[0] instanceof IFile)) {
            return;
        }
        IFile theFile = (IFile)result[0];
        IPath fullPath = theFile.getFullPath();
        IPath relativePath = fullPath.removeFirstSegments(1);
        String filePath = relativePath.toString();
        this.resetPasswords();
        String displayPath = SignatureProperties.toRelative((String)filePath);
        this.sigProps.setKeyStoreDisplayPath(displayPath);
        this.keystoreTxt.setText(displayPath);
        this.loadAliases();
    }

    private void loadAliases() {
        File keyStoreFile = null;
        try {
            String path = this.sigProps.getAbsoluteKeyStorePath(this.getProject());
            if (path == null) {
                return;
            }
            keyStoreFile = new File(path);
            if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
                return;
            }
            if (this.sigProps.getPasswordStorageMethod() != 0) {
                String kstPassword = this.keystorePasswordTxt.getText();
                this.keyStoreManager = new DefaultKeyStoreManager(keyStoreFile, kstPassword);
                this.keyStoreManager.setProvider(this.signingBlock.getProvider());
                this.keyStoreManager.setKeystoreType(this.signingBlock.getKeystoreType());
                this.signingBlock.setInput((IKeyStoreManager)this.keyStoreManager);
                this.passwordBtn.setEnabled(true);
                String alias = this.sigProps.getKeyAlias();
                if (alias != null) {
                    this.signingBlock.setCurrentAlias(alias);
                }
            } else {
                this.openKeyStorePasswordDialog(keyStoreFile);
            }
        }
        catch (CoreException e) {
            String message = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToGetKeystoreAliases, (Object)e.getMessage());
            this.setErrorMessage(message);
            MTJLogger.log((int)4, (String)message);
        }
    }

    private void openKeyStorePasswordDialog(final File keyStoreFile) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SigningPasswordDialog dialog = new SigningPasswordDialog(SigningPropertiesPage.this.getShell(), true);
                dialog.setTitle(MTJUIMessages.SigningPropertiesPage_enterPassword);
                dialog.setDescription(MTJUIMessages.SigningPropertiesPage_enterKeystorePassword);
                if (dialog.open() != 0) {
                    return;
                }
                String kstPassword = dialog.getPassword();
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(0);
                if (dialog.isSavingInWorkspace()) {
                    SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(1);
                    SigningPropertiesPage.this.keystorePasswordTxt.setText(kstPassword);
                    SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(true);
                    SigningPropertiesPage.this.keyPasswordTxt.setEnabled(true);
                    SigningPropertiesPage.this.ksPasswordBtn2.setSelection(true);
                    SigningPropertiesPage.this.ksPasswordBtn1.setSelection(false);
                    SigningPropertiesPage.this.ksPasswordBtn3.setSelection(false);
                }
                SigningPropertiesPage.this.keyStoreManager = new DefaultKeyStoreManager(keyStoreFile, kstPassword);
                SigningPropertiesPage.this.keyStoreManager.setProvider(SigningPropertiesPage.this.signingBlock.getProvider());
                SigningPropertiesPage.this.keyStoreManager.setKeystoreType(SigningPropertiesPage.this.signingBlock.getKeystoreType());
                SigningPropertiesPage.this.signingBlock.setInput((IKeyStoreManager)SigningPropertiesPage.this.keyStoreManager);
                SigningPropertiesPage.this.passwordBtn.setEnabled(true);
            }
        });
    }

    private String convertNullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private IMidletSuiteProject getMidletSuiteProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
        return midletProject;
    }

    private IProject getProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        } else if (adaptable instanceof IJavaProject) {
            project = ((IJavaProject)adaptable).getProject();
        }
        return project;
    }

    private boolean isJ2MEProject(IProject project) {
        boolean j2meProject = false;
        if (project != null) {
            try {
                IProjectNature nature = project.getNature("org.eclipse.mtj.core.nature");
                j2meProject = nature != null;
            }
            catch (CoreException coreException) {}
        }
        return j2meProject;
    }

    private void loadSigningData() {
        boolean isProjectSpecific = this.sigProps.isProjectSpecific();
        this.projectSpecificBtn.setSelection(isProjectSpecific);
        this.setEnabled(isProjectSpecific);
        this.keystoreTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreDisplayPath()));
        this.keystorePasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
        this.keyPasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyPassword()));
        int passwdType = this.sigProps.getPasswordStorageMethod();
        switch (passwdType) {
            case 2: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn3.setSelection(true);
                break;
            }
            case 1: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn3.setSelection(false);
                this.ksPasswordBtn2.setSelection(true);
                break;
            }
            case 0: {
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn3.setSelection(false);
                this.ksPasswordBtn1.setSelection(true);
            }
        }
        this.signingBlock.setProvider(this.sigProps.getKeyStoreProvider());
        this.signingBlock.setKeystoreType(this.sigProps.getKeyStoreType());
        if (isProjectSpecific) {
            this.loadAliases();
        }
    }

    protected Control createContents(Composite parent) {
        this.loadSigningProperties();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mtj.ui.help_J2MEProjectPropertiesPage");
        IProject project = this.getProject();
        if (!this.isJ2MEProject(project)) {
            Label lbl = new Label(parent, 0);
            lbl.setText(MTJUIMessages.J2MESigningPropertiesPage_error_not_midlet_project);
            return lbl;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.projectSpecificBtn = new Button(composite, 32);
        this.projectSpecificBtn.setText(MTJUIMessages.SigningPropertiesPage_enableProjectSpecific);
        this.projectSpecificBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, false));
        this.projectSpecificBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPropertiesPage.this.loadSigningProperties();
                SigningPropertiesPage.this.sigProps.setProjectSpecific(SigningPropertiesPage.this.projectSpecificBtn.getSelection());
                SigningPropertiesPage.this.setEnabled(SigningPropertiesPage.this.sigProps.isProjectSpecific());
                if (SigningPropertiesPage.this.sigProps.isSignProject() && SigningPropertiesPage.this.sigProps.isProjectSpecific()) {
                    SigningPropertiesPage.this.loadAliases();
                }
            }
        });
        this.createKeyStoreSection(composite);
        this.signingBlock = new SigningBlock();
        this.signingBlock.createBlock(composite);
        this.loadSigningData();
        return composite;
    }

    private void loadSigningProperties() {
        IMidletSuiteProject midletProject = this.getMidletSuiteProject();
        ISignatureProperties props = null;
        try {
            props = midletProject.getSignatureProperties();
        }
        catch (CoreException coreException) {}
        this.sigProps = new SignatureProperties();
        if (props != null) {
            this.sigProps.copy(props);
        } else {
            this.sigProps.clear();
        }
    }

    private void setEnabled(boolean enabled) {
        this.keystoreTxt.setEnabled(enabled);
        this.ksPasswordBtn3.setEnabled(enabled);
        this.ksPasswordBtn2.setEnabled(enabled);
        this.ksPasswordBtn1.setEnabled(enabled);
        this.passwordBtn.setEnabled(enabled);
        this.externalBtn.setEnabled(enabled);
        this.projectBtn.setEnabled(enabled);
        this.signingBlock.setEnabled(enabled);
        boolean enablePasswords = this.sigProps.getPasswordStorageMethod() != 0;
        this.keystorePasswordTxt.setEnabled(enablePasswords && enabled);
        this.keyPasswordTxt.setEnabled(enablePasswords && enabled);
    }

    private void createKeyStoreSection(Composite parent) {
        Group ksGroup = new Group(parent, 0);
        ksGroup.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 0;
        ksGroup.setLayout((Layout)layout);
        ksGroup.setText(MTJUIMessages.SigningPropertiesPage_keystore);
        Label location = new Label((Composite)ksGroup, 0);
        location.setText(MTJUIMessages.SigningPropertiesPage_location);
        GridData gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 4;
        location.setLayoutData((Object)gridData);
        this.keystoreTxt = new Text((Composite)ksGroup, 2048);
        this.keystoreTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.projectBtn = new Button((Composite)ksGroup, 0);
        this.projectBtn.setText(MTJUIMessages.SigningPropertiesPage_project);
        this.projectBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.projectBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                SigningPropertiesPage.this.browseProjectForKeystore();
            }
        });
        this.externalBtn = new Button((Composite)ksGroup, 0);
        this.externalBtn.setText(MTJUIMessages.SigningPropertiesPage_external);
        this.externalBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.externalBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                SigningPropertiesPage.this.browseExternalForKeystore();
            }
        });
        this.passwordBtn = new Button((Composite)ksGroup, 0);
        this.passwordBtn.setText(MTJUIMessages.SigningPropertiesPage_changePassword);
        this.passwordBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.passwordBtn.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (SigningPropertiesPage.this.keyStoreManager == null) {
                    return;
                }
                SigningPasswordDialog dialog = new SigningPasswordDialog(SigningPropertiesPage.this.getShell(), false);
                dialog.setTitle("Change Keystore Password");
                dialog.setDescription("Enter the new keystore password");
                if (dialog.open() != 0) {
                    return;
                }
                String kstPassword = dialog.getPassword();
                try {
                    SigningPropertiesPage.this.keyStoreManager.changeKeystorePassword(kstPassword);
                    IMidletSuiteProject midletProject = SigningPropertiesPage.this.getMidletSuiteProject();
                    SigningPropertiesPage.this.sigProps.setKeyStorePassword(kstPassword);
                    midletProject.setSignatureProperties(SigningPropertiesPage.this.sigProps);
                    midletProject.saveMetaData();
                    if (SigningPropertiesPage.this.sigProps.getPasswordStorageMethod() != 0) {
                        SigningPropertiesPage.this.keystorePasswordTxt.setText(SigningPropertiesPage.this.sigProps.getKeyStorePassword());
                    }
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)SigningPropertiesPage.this.getShell(), (String)"Keystore Manager Error", (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
                catch (CoreException exc) {
                    String message = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToSaveSuiteMetadata, (Object)exc.getMessage());
                    MTJLogger.log((int)4, (String)message);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Composite passwordGroup = new Composite((Composite)ksGroup, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        passwordGroup.setLayoutData((Object)gridData);
        passwordGroup.setLayout((Layout)new GridLayout(3, true));
        this.ksPasswordBtn1 = new Button(passwordGroup, 16);
        this.ksPasswordBtn1.setText(MTJUIMessages.SigningPropertiesPage_prompForPassword);
        this.ksPasswordBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(!SigningPropertiesPage.this.ksPasswordBtn1.getSelection());
                SigningPropertiesPage.this.keystorePasswordTxt.setText("");
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(!SigningPropertiesPage.this.ksPasswordBtn1.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setText("");
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(0);
                SigningPropertiesPage.this.sigProps.setKeyStorePassword("");
                SigningPropertiesPage.this.sigProps.setKeyPassword("");
            }
        });
        this.ksPasswordBtn2 = new Button(passwordGroup, 16);
        this.ksPasswordBtn2.setText(MTJUIMessages.SigningPropertiesPage_savePasswordInWorkspace);
        this.ksPasswordBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn2.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn2.getSelection());
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(1);
            }
        });
        this.ksPasswordBtn3 = new Button(passwordGroup, 16);
        this.ksPasswordBtn3.setText(MTJUIMessages.SigningPropertiesPage_savePasswordInProject);
        this.ksPasswordBtn3.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.ksPasswordBtn3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn3.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn3.getSelection());
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(2);
            }
        });
        Composite ksPasswordGroup = new Composite((Composite)ksGroup, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        ksPasswordGroup.setLayoutData((Object)gridData);
        ksPasswordGroup.setLayout((Layout)new GridLayout(2, false));
        Label kstPasswordLabel = new Label(ksPasswordGroup, 0);
        kstPasswordLabel.setText(MTJUIMessages.SigningPropertiesPage_keyStorePassword);
        kstPasswordLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keystorePasswordTxt = new Text(ksPasswordGroup, 2048);
        this.keystorePasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.keystorePasswordTxt.setEnabled(false);
        Label keyPasswordLabel = new Label(ksPasswordGroup, 0);
        keyPasswordLabel.setText(MTJUIMessages.SigningPropertiesPage_keyPassword);
        keyPasswordLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keyPasswordTxt = new Text(ksPasswordGroup, 2048);
        this.keyPasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.keyPasswordTxt.setEnabled(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setErrorMessage(null);
        boolean signProject = this.sigProps.isSignProject();
        this.sigProps.clear();
        this.sigProps.setSignProject(signProject);
        this.signingBlock.setInput(null);
        this.setEnabled(false);
        try {
            this.sigProps = new PreferencesSignatureProperties();
            this.loadSigningData();
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }
}

