/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.statusHandlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class DebuggerSettingCheckHandler
implements IStatusHandler {
    public static final boolean CORRECT_SUSPENDONCOMPILEERR_SETTING = false;
    public static final boolean CORRECT_SUSPENDONUNCAUGHTEXP_SETTING = false;
    public static final int MIN_DEBUGGERTIMEOUT_SETTING = 15000;
    public static final String PREF_DEBUGSETTING_WARNING = "org.eclipse.mtj.ui.debugSettingWarning";

    public void configDebuggerSetting() {
        boolean answer;
        IStatus debugSettingStatus = this.debugSettingSatisfied();
        if (debugSettingStatus.isOK()) {
            return;
        }
        String preferenceKey = PREF_DEBUGSETTING_WARNING;
        String debugWarningDesc = MTJUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("neverWarning".equals(debugWarningDesc)) {
            return;
        }
        Shell shell = this.getShell();
        ErrorDialogWithToggle dialog = new ErrorDialogWithToggle(shell, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_title, null, debugSettingStatus, preferenceKey, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_toggleMessage, MTJUIPlugin.getDefault().getPreferenceStore());
        dialog.open();
        boolean bl = answer = dialog.getReturnCode() == 2;
        if (answer) {
            JDIDebugModel.getPreferences().setValue(JDIDebugModel.PREF_REQUEST_TIMEOUT, 15000);
            JavaDebugUtils.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, false);
            JavaDebugUtils.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, false);
        }
    }

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        this.configDebuggerSetting();
        return Boolean.TRUE;
    }

    private IStatus debugSettingSatisfied() {
        boolean suspendOnUnCaughtExp = JavaDebugUtils.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS);
        boolean suspendOnCompileErr = JavaDebugUtils.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS);
        int currReqTimeout = JDIDebugModel.getPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
        if (!suspendOnUnCaughtExp && !suspendOnCompileErr && currReqTimeout >= 15000) {
            return new Status(0, "org.eclipse.mtj.ui", "");
        }
        MultiStatus warningStatus = new MultiStatus("org.eclipse.mtj.ui", 2, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_warningMessage, null);
        if (suspendOnUnCaughtExp) {
            warningStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_suspendOnUnCaughtExpWarning));
        }
        if (suspendOnCompileErr) {
            warningStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_suspendOnCompileErrWarning));
        }
        if (currReqTimeout < 15000) {
            warningStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", NLS.bind((String)MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_reqestTimeoutWarning, (Object[])new Integer[]{15000})));
        }
        return warningStatus;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    class ErrorDialogWithToggle
    extends ErrorDialog {
        public static final String NO_WARING = "neverWarning";
        private String fPreferenceKey;
        private Button fToggleButton;
        private String fToggleMessage;
        private boolean toggleState;
        IPreferenceStore prefStore;

        public ErrorDialogWithToggle(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, IPreferenceStore store) {
            super(parentShell, dialogTitle, message, status, 7);
            this.fPreferenceKey = null;
            this.fToggleButton = null;
            this.fToggleMessage = null;
            this.prefStore = null;
            this.prefStore = store;
            this.fPreferenceKey = preferenceKey;
            this.fToggleMessage = toggleMessage;
        }

        private Button createCheckButton(Composite parent, String label) {
            final Button button = new Button(parent, 16416);
            button.setText(label);
            GridData data = new GridData(0);
            data.horizontalSpan = 2;
            data.horizontalAlignment = 2;
            button.setLayoutData((Object)data);
            button.setFont(parent.getFont());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ErrorDialogWithToggle.this.toggleState = button.getSelection();
                }
            });
            return button;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId != 13) {
                if (this.toggleState && this.prefStore != null && this.fPreferenceKey != null) {
                    this.prefStore.setValue(this.fPreferenceKey, NO_WARING);
                }
                this.setReturnCode(buttonId);
                this.close();
            }
            super.buttonPressed(buttonId);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createDetailsButton(parent);
            this.getButton(2).setFocus();
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogComposite = (Composite)super.createDialogArea(parent);
            dialogComposite.setFont(parent.getFont());
            this.setToggleButton(this.createCheckButton(dialogComposite, this.fToggleMessage));
            ErrorDialogWithToggle.applyDialogFont((Control)dialogComposite);
            return dialogComposite;
        }

        protected Button getToggleButton() {
            return this.fToggleButton;
        }

        protected void setToggleButton(Button button) {
            this.fToggleButton = button;
        }
    }
}

