/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.statusHandlers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.internal.core.build.sign.SignaturePasswords;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordsDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SignaturePasswordHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) {
        Display display = Display.getCurrent();
        Object[] array = (Object[])source;
        DialogRunner runner = new DialogRunner((IProject)array[0], (String)array[1], (String)array[2]);
        display.syncExec((Runnable)runner);
        return runner.getPasswords();
    }

    private static class DialogRunner
    implements Runnable {
        IProject project;
        SignaturePasswords passwords;

        public DialogRunner(IProject project, String keyStorePass, String privateKeyPass) {
            this.project = project;
            this.passwords = new SignaturePasswords();
            this.passwords.setKeystorePassword(keyStorePass);
            this.passwords.setKeyPassword(privateKeyPass);
        }

        public void run() {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            if (shell == null) {
                shell = new Shell(display, 0);
            }
            SigningPasswordsDialog dlg = new SigningPasswordsDialog(shell, this.project);
            dlg.setKeystorePassword(this.passwords.getKeystorePassword());
            dlg.setKeyPassword(this.passwords.getKeyPassword());
            if (dlg.open() != 0) {
                this.passwords = null;
            } else {
                this.passwords = new SignaturePasswords();
                this.passwords.setKeystorePassword(dlg.getKeystorePassword());
                this.passwords.setKeyPassword(dlg.getKeyPassword());
            }
        }

        public SignaturePasswords getPasswords() {
            return this.passwords;
        }
    }
}

