/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.templates.midlets;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDletTemplateRegistry
implements IRegistryChangeListener {
    private static final String TEMPLATE_EXT_ID = "org.eclipse.mtj.ui.midlettemplate";
    private static final String PLUGIN_ID = "org.eclipse.mtj.ui";
    private static final String EXT_TEMPLATE = "midlettemplate";
    private static MIDletTemplateRegistry instance;
    private Map<String, MIDletTemplateObject> extensions;

    public static synchronized MIDletTemplateRegistry getInstance() {
        if (instance == null) {
            instance = new MIDletTemplateRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)instance);
        }
        return instance;
    }

    private MIDletTemplateRegistry() {
        IExtensionRegistry registry = null;
        IConfigurationElement[] extensions = null;
        MIDletTemplateObject object = null;
        this.extensions = new Hashtable<String, MIDletTemplateObject>();
        registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(TEMPLATE_EXT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            object = new MIDletTemplateObject(extension);
            this.extensions.put(object.getName(), object);
            ++n2;
        }
    }

    public Collection<MIDletTemplateObject> getTemplates() {
        return this.extensions.values();
    }

    public MIDletTemplateObject getTemplate(String name) {
        return this.extensions.get(name);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(PLUGIN_ID, EXT_TEMPLATE);
        int i = 0;
        while (i < deltas.length) {
            MIDletTemplateObject object;
            IConfigurationElement element;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] elements;
            if (deltas[i].getKind() == 1) {
                iConfigurationElementArray = elements = deltas[i].getExtension().getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    object = new MIDletTemplateObject(element);
                    this.extensions.put(object.getName(), object);
                    ++n;
                }
            } else {
                iConfigurationElementArray = elements = deltas[i].getExtension().getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    object = new MIDletTemplateObject(element);
                    this.extensions.remove(object.getName());
                    ++n;
                }
            }
            ++i;
        }
    }
}

