/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ImageSelectionDialogCreator {
    public static SelectionDialog createImageSelectionDialog(Shell shell, IJavaProject javaProject) {
        final ArrayList imageResourcesList = new ArrayList();
        ArrayList<Object> srcFoldersPaths = new ArrayList<Object>();
        IClasspathEntry[] classpathEntries = null;
        try {
            classpathEntries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getContentKind() == 1) {
                IPath srcFolderPath = entry.getPath();
                if (srcFolderPath.segmentCount() > 1) {
                    srcFoldersPaths.add(javaProject.getProject().getFolder(srcFolderPath.removeFirstSegments(1)));
                } else {
                    srcFoldersPaths.add(javaProject.getProject());
                }
            }
            ++n2;
        }
        try {
            Iterator iterator = srcFoldersPaths.iterator();
            while (iterator.hasNext()) {
                IResource srcFlder;
                IResource resource = srcFlder = (IResource)iterator.next();
                resource.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.isDerived()) {
                            return false;
                        }
                        int type = proxy.getType();
                        if ((1 & type) != 0) {
                            IResource res = proxy.requestResource();
                            String fileExtension = res.getFileExtension();
                            if (fileExtension != null && (fileExtension.equalsIgnoreCase("gif") || fileExtension.equalsIgnoreCase("png") || fileExtension.equalsIgnoreCase("jpg"))) {
                                imageResourcesList.add(res);
                                return true;
                            }
                            return false;
                        }
                        return type != 1;
                    }
                }, 0);
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (String)"createImageSelectionDialog", (Throwable)e);
        }
        Object[] imageResourcesArray = imageResourcesList.toArray(new IResource[0]);
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IResource[])imageResourcesArray);
        dialog.setInitialSelections(imageResourcesArray);
        dialog.setTitle(MTJUIMessages.ImageSelectionDialogCreator_title);
        return dialog;
    }
}

