/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.viewers;

import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewerConfiguration {
    private static final String SORT_COLUMN = "sortColumn";
    private static final String SORT_DIRECTION = "sortDirection";
    private IDialogSettings dialogSettings;
    private TableColumnInfo[] columnInfo;
    private int defaultSortColumn;
    private int defaultTableWidth;
    private String[] columnWidthKeys;
    private Image downArrow;
    private Image upArrow;

    public TableViewerConfiguration(IDialogSettings dialogSettings, int defaultTableWidth, TableColumnInfo[] columnInfo, int defaultSortColumn) {
        this.dialogSettings = dialogSettings;
        this.columnInfo = columnInfo;
        this.defaultSortColumn = defaultSortColumn;
        this.defaultTableWidth = defaultTableWidth;
        this.columnWidthKeys = new String[columnInfo.length];
        int i = 0;
        while (i < columnInfo.length) {
            TableColumnInfo info = columnInfo[i];
            this.columnWidthKeys[i] = "columnWidth_" + info.getName();
            ++i;
        }
        this.downArrow = MTJUIPluginImages.DESC_DOWN_ARROW_OBJ.createImage();
        this.upArrow = MTJUIPluginImages.DESC_UP_ARROW_OBJ.createImage();
    }

    public void configure(TableViewer viewer) {
        TableViewerInfoSorter sorter = new TableViewerInfoSorter();
        sorter.setComparator(this.getComparator(viewer));
        viewer.setSorter((ViewerSorter)sorter);
        Table table = viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        int i = 0;
        while (i < this.columnInfo.length) {
            TableColumnInfo info = this.columnInfo[i];
            TableColumn column = new TableColumn(table, info.getAlignment());
            column.setText(info.getName());
            int columnWidth = this.getColumnWidth(i);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(columnWidth));
            TableColumnListener listener = new TableColumnListener(viewer, i);
            column.addControlListener((ControlListener)listener);
            column.addSelectionListener((SelectionListener)listener);
            ++i;
        }
        this.updateSortImages(viewer);
    }

    public TableColumnInfo[] getColumnInfo() {
        return this.columnInfo;
    }

    private int getColumnWidth(int columnIndex) {
        int width = 0;
        String key = this.columnWidthKeys[columnIndex];
        if (this.dialogSettings.get(key) != null) {
            width = this.dialogSettings.getInt(key);
        } else {
            float percent = this.columnInfo[columnIndex].getDefaultWidthPercent() / 100.0f;
            width = (int)((float)this.defaultTableWidth * percent);
        }
        return width;
    }

    private Comparator<Object> getComparator(TableViewer viewer) {
        TableColumnInfo info = this.columnInfo[this.getSortColumn()];
        Comparator<Object> comparator = info.getComparator();
        if (comparator == null) {
            comparator = new LabelProviderComparator(viewer, this.getSortColumn());
        }
        if (!this.getSortDirectionAscending()) {
            comparator = new ReversingComparator(comparator);
        }
        return comparator;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public int getSortColumn() {
        return this.dialogSettings.get(SORT_COLUMN) != null ? this.dialogSettings.getInt(SORT_COLUMN) : this.defaultSortColumn;
    }

    public boolean getSortDirectionAscending() {
        return this.dialogSettings.get(SORT_DIRECTION) != null ? this.dialogSettings.getBoolean(SORT_DIRECTION) : true;
    }

    public void setColumnInfo(TableColumnInfo[] columnInfo) {
        this.columnInfo = columnInfo;
    }

    private void setColumnWidth(int columnIndex, int width) {
        String key = this.columnWidthKeys[columnIndex];
        this.dialogSettings.put(key, width);
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public void setSortColumn(int columnIndex) {
        this.dialogSettings.put(SORT_COLUMN, columnIndex);
    }

    public void setSortDirectionAscending(boolean ascending) {
        this.dialogSettings.put(SORT_DIRECTION, ascending);
    }

    private void updateSortImages(TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            Image image = null;
            if (i == this.getSortColumn()) {
                image = this.getSortDirectionAscending() ? this.downArrow : this.upArrow;
            }
            columns[i].setImage(image);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelProviderComparator
    implements Comparator<Object> {
        private TableViewer tableViewer;
        private int columnIndex;

        LabelProviderComparator(TableViewer tableViewer, int columnIndex) {
            this.tableViewer = tableViewer;
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(Object o1, Object o2) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)this.tableViewer.getLabelProvider();
            String label1 = this.getLabel(labelProvider, o1);
            String label2 = this.getLabel(labelProvider, o2);
            return label1.compareToIgnoreCase(label2);
        }

        private String getLabel(ITableLabelProvider labelProvider, Object object) {
            return labelProvider.getColumnText(object, this.columnIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReversingComparator
    implements Comparator<Object> {
        private Comparator<Object> baseComparator;

        ReversingComparator(Comparator<Object> baseComparator) {
            this.baseComparator = baseComparator;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return 0 - this.baseComparator.compare(o1, o2);
        }
    }

    private class TableColumnListener
    implements ControlListener,
    SelectionListener {
        private TableViewer viewer;
        private int columnIndex;

        TableColumnListener(TableViewer viewer, int columnIndex) {
            this.viewer = viewer;
            this.columnIndex = columnIndex;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            TableColumn column = (TableColumn)e.widget;
            TableViewerConfiguration.this.setColumnWidth(this.columnIndex, column.getWidth());
        }

        private void updateViewerSorter() {
            ViewerSorter sorter = this.viewer.getSorter();
            if (sorter instanceof TableViewerInfoSorter) {
                TableViewerInfoSorter infoSorter = (TableViewerInfoSorter)sorter;
                infoSorter.setComparator(TableViewerConfiguration.this.getComparator(this.viewer));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int currentSortColumn = TableViewerConfiguration.this.getSortColumn();
            if (currentSortColumn == this.columnIndex) {
                TableViewerConfiguration.this.setSortDirectionAscending(!TableViewerConfiguration.this.getSortDirectionAscending());
            } else {
                TableViewerConfiguration.this.setSortColumn(this.columnIndex);
                TableViewerConfiguration.this.setSortDirectionAscending(true);
            }
            TableViewerConfiguration.this.updateSortImages(this.viewer);
            this.updateViewerSorter();
            this.viewer.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableViewerInfoSorter
    extends ViewerSorter {
        private Comparator<Object> comparator;

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.comparator.compare(e1, e2);
        }

        public void setComparator(Comparator<Object> comparator) {
            this.comparator = comparator;
        }
    }
}

