/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedListDialogField
extends ListDialogField {
    private int fCheckAllButtonIndex = -1;
    private List<Object> fCheckedElements = new ArrayList<Object>();
    private List<Object> fGrayedElements = new ArrayList<Object>();
    private int fUncheckAllButtonIndex = -1;

    public CheckedListDialogField(IListAdapter adapter, String[] customButtonLabels, ILabelProvider lprovider) {
        super(adapter, customButtonLabels, lprovider);
    }

    public void checkAll(boolean state) {
        if (state) {
            this.fCheckedElements = this.getElements();
        } else {
            this.fCheckedElements.clear();
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(state);
        }
        this.checkStateChanged();
    }

    @Override
    public void dialogFieldChanged() {
        int i = this.fCheckedElements.size() - 1;
        while (i >= 0) {
            if (!this.fElements.contains(this.fCheckedElements.get(i))) {
                this.fCheckedElements.remove(i);
            }
            --i;
        }
        super.dialogFieldChanged();
    }

    public List<Object> getCheckedElements() {
        if (this.isOkToUse(this.fTableControl)) {
            Object[] checked = ((CheckboxTableViewer)this.fTable).getCheckedElements();
            ArrayList<Object> res = new ArrayList<Object>(checked.length);
            Object[] objectArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                res.add(element);
                ++n2;
            }
            return res;
        }
        return new ArrayList<Object>(this.fCheckedElements);
    }

    public int getCheckedSize() {
        return this.fCheckedElements.size();
    }

    @Override
    public Control getListControl(Composite parent) {
        Control control = super.getListControl(parent);
        if (parent != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
        return control;
    }

    public boolean isChecked(Object obj) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getChecked(obj);
        }
        return this.fCheckedElements.contains(obj);
    }

    public boolean isGrayed(Object obj) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getGrayed(obj);
        }
        return this.fGrayedElements.contains(obj);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
    }

    @Override
    public void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        boolean wasChecked = this.isChecked(oldElement);
        super.replaceElement(oldElement, newElement);
        this.setChecked(newElement, wasChecked);
    }

    public void setCheckAllButtonIndex(int checkButtonIndex) {
        Assert.isTrue((checkButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = checkButtonIndex;
    }

    public void setChecked(Object object, boolean state) {
        this.setCheckedWithoutUpdate(object, state);
        this.checkStateChanged();
    }

    public void setCheckedElements(Collection<Object> list) {
        this.fCheckedElements = new ArrayList<Object>(list);
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(list.toArray());
        }
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(Object object, boolean state) {
        if (state) {
            if (!this.fCheckedElements.contains(object)) {
                this.fCheckedElements.add(object);
            }
        } else {
            this.fCheckedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, state);
        }
    }

    public void setGrayedWithoutUpdate(Object object, boolean state) {
        if (state) {
            if (!this.fGrayedElements.contains(object)) {
                this.fGrayedElements.add(object);
            }
        } else {
            this.fGrayedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setGrayed(object, state);
        }
    }

    public void setUncheckAllButtonIndex(int uncheckButtonIndex) {
        Assert.isTrue((uncheckButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = uncheckButtonIndex;
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    private void doCheckStateChanged(CheckStateChangedEvent e) {
        if (e.getChecked()) {
            this.fCheckedElements.add(e.getElement());
        } else {
            this.fCheckedElements.remove(e.getElement());
        }
        this.checkStateChanged();
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 32 + this.getListStyle());
        table.setFont(parent.getFont());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                CheckedListDialogField.this.doCheckStateChanged(e);
            }
        });
        return tableViewer;
    }

    @Override
    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (index == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(sel, index);
    }

    @Override
    protected boolean managedButtonPressed(int index) {
        if (index == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (index == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(index);
        }
        return true;
    }
}

