/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import org.eclipse.mtj.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IComboButtonAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboButtonDialogField
extends ComboDialogField {
    private IComboButtonAdapter fComboButtonAdapter;
    private Button fSelectButton;
    private String fSelectButtonLabel;
    private boolean fButtonEnabled;

    protected static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public ComboButtonDialogField(IComboButtonAdapter adapter, int comboStyle) {
        super(comboStyle);
        this.fComboButtonAdapter = adapter;
        this.fSelectButtonLabel = "!Select...!";
        this.fButtonEnabled = true;
    }

    public void changeControlPressed() {
        this.fComboButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ComboButtonDialogField.gridDataForLabel(1));
        Combo combo = this.getComboControl(parent);
        combo.setLayoutData((Object)new GridData(768));
        Button button = this.getChangeControl(parent);
        button.setLayoutData((Object)ComboButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, combo, button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fSelectButton)) {
            this.fSelectButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    public Button getChangeControl(Composite parent) {
        if (this.fSelectButton == null) {
            this.assertCompositeNotNull(parent);
            this.fSelectButton = new Button(parent, 8);
            this.fSelectButton.setFont(parent.getFont());
            this.fSelectButton.setText(this.fSelectButtonLabel);
            this.fSelectButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fSelectButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fSelectButton;
    }

    public void setButtonLabel(String label) {
        this.fSelectButtonLabel = label;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fSelectButton)) {
            this.fSelectButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

