/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private DialogField[] fAttachedDialogFields = null;
    private Button fButton;
    private int fButtonStyle;
    private boolean fIsSelected = false;

    public SelectionButtonDialogField(int buttonStyle) {
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        DialogField[] dialogFieldArray = dialogFields;
        int n = dialogFields.length;
        int n2 = 0;
        while (n2 < n) {
            DialogField dialogField = dialogFieldArray[n2];
            dialogField.setEnabled(this.fIsSelected);
            ++n2;
        }
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Button button = this.getSelectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
        return new Control[]{button};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }
            });
        }
        return this.fButton;
    }

    public boolean isAttached(DialogField editor) {
        if (this.fAttachedDialogFields != null) {
            DialogField[] dialogFieldArray = this.fAttachedDialogFields;
            int n = this.fAttachedDialogFields.length;
            int n2 = 0;
            while (n2 < n) {
                DialogField attachedDialogField = dialogFieldArray[n2];
                if (attachedDialogField == editor) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(labeltext);
        }
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                DialogField[] dialogFieldArray = this.fAttachedDialogFields;
                int n = this.fAttachedDialogFields.length;
                int n2 = 0;
                while (n2 < n) {
                    DialogField attachedDialogField = dialogFieldArray[n2];
                    attachedDialogField.setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !focusSet) {
                        focusSet = attachedDialogField.setFocus();
                    }
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    private void doWidgetSelected(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }
}

