/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.export.packaging;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.wizards.export.packaging.MidletPackageExportPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class MidletPackageExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection fSelection;
    private MidletPackageExportPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(MTJUIMessages.MidletPackageExportWizardTitle);
        this.setDefaultPageImageDescriptor(MTJUIPluginImages.DESC_MIDLET_JAR_EXPORT_WIZ);
        this.setNeedsProgressMonitor(true);
        this.fSelection = selection;
        IDialogSettings section = MTJUIPlugin.getDialogSettings("MidletPackageExportWizard");
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.page = new MidletPackageExportPage();
        List projects = this.fSelection.toList();
        this.page.setSelectedProjects(projects);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map<IJavaProject, List<MTJRuntime>> selection = MidletPackageExportWizard.this.page.getProjectSelections();
                    SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.size());
                    for (IJavaProject javaProject : selection.keySet()) {
                        if (localMonitor.isCanceled()) {
                            return;
                        }
                        MidletSuiteProject midletProject = (MidletSuiteProject)MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
                        try {
                            String destination = null;
                            if (!MidletPackageExportWizard.this.page.getUseDeployed()) {
                                destination = MidletPackageExportWizard.this.page.getDestinationDirectory();
                            }
                            midletProject.createPackage(selection.get(javaProject), MidletPackageExportWizard.this.page.getObfuscate(), destination, (IProgressMonitor)localMonitor.newChild(1));
                        }
                        catch (CoreException e) {
                            MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "Failed to export midlet jars", (Throwable)e));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "Failed to export midlet jar files", (Throwable)e));
        }
        this.page.finish();
        return true;
    }
}

