/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;

public class ProjectRecord {
    private String projectRoot;
    private String projectName;
    private ILeveledImportStructureProvider provider = null;

    public ILeveledImportStructureProvider getProvider() {
        return this.provider;
    }

    public ProjectRecord(String projectName, String projectRoot) {
        this.projectName = projectName;
        this.projectRoot = projectRoot;
    }

    public ProjectRecord() {
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String root) {
        this.projectRoot = root;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectLabel() {
        return String.valueOf(this.projectName) + " (" + this.projectRoot + ")";
    }

    public void setProvider(ILeveledImportStructureProvider provider) {
        this.provider = provider;
    }

    public InputStream getResourceContents(String file) throws FileNotFoundException {
        if (this.provider != null) {
            Object parentElement = ArchiveUtils.getChild(this.provider, this.provider.getRoot(), this.projectRoot);
            Object fileElement = ArchiveUtils.getChild(this.provider, parentElement, file);
            return this.provider.getContents(fileElement);
        }
        return new FileInputStream(new File(this.projectRoot, file));
    }
}

