/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.l10n.LocalizationPage;

public class LocalizationWizard
extends Wizard {
    private LocalizationPage page;
    private IJavaProject jProject;

    public LocalizationWizard(IJavaProject project) {
        this.jProject = project;
        this.setWindowTitle(MTJUIMessages.LocalizationWizard_window_title);
    }

    public void addPages() {
        this.page = new LocalizationPage(this.jProject, this.getContainer());
        this.addPage((IWizardPage)this.page);
    }

    public boolean canFinish() {
        IResource destination = this.page.getDestination();
        IJavaElement targetPack = this.page.getPackage();
        return destination != null && targetPack != null;
    }

    public boolean performFinish() {
        IResource properties = this.page.getDestination();
        IJavaElement targetPack = this.page.getPackage();
        boolean result = false;
        if (targetPack instanceof IPackageFragment) {
            try {
                result = L10nApi.createLocalizationFile((IProject)this.jProject.getProject(), (IPath)properties.getProjectRelativePath(), (IJavaElement)targetPack);
                this.jProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                result &= L10nApi.createLocalizationApi((IProject)this.jProject.getProject(), (IPackageFragment)((IPackageFragment)targetPack), (IPath)properties.getProjectRelativePath());
                this.jProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

