/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.wizards.l10n.ClassFileStringsContentProvider;
import org.eclipse.mtj.internal.ui.wizards.l10n.ClassFileStringsLabelProvider;
import org.eclipse.mtj.internal.ui.wizards.l10n.RegExpStringExternalizer;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StringLocalizationWizardPage1
extends WizardPage {
    private static final String[] COLUMNS = new String[]{MTJUIMessages.StringLocalizationWizardPage1_valueColumn, MTJUIMessages.StringLocalizationWizardPage1_keyColumn};
    private IBuffer buffer;
    private TableViewer viewer;
    private Table table;
    private Text text;
    private RegExpStringExternalizer externalizer;

    protected StringLocalizationWizardPage1(String _name, IBuffer _buffer) {
        super("StringLocalizationWizardPage1");
        if (_buffer == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizardPage1_nullBuffer);
        }
        this.setTitle(NLS.bind((String)MTJUIMessages.StringLocalizationWizardPage1_pageTitle, (Object)_name));
        this.setImageDescriptor(MTJUIPluginImages.DESC_ADD_L10N);
        this.externalizer = new RegExpStringExternalizer();
        this.buffer = _buffer;
        String content = this.buffer.getContents();
        if (Platform.getOS().equals("win32")) {
            content = content.replaceAll("\n", "\r\n");
            this.buffer.setContents(content);
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        main.setLayout((Layout)layout);
        this.createTableSection(main);
        this.createSourceSection(main);
        this.setControl((Control)main);
    }

    public StringLocalizationData[] getExternalizedStrings() {
        TableItem[] items;
        ArrayList<StringLocalizationData> result = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object object = item.getData();
            if (item.getChecked() && !item.getGrayed() && object instanceof StringLocalizationData) {
                result.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return result.toArray(new StringLocalizationData[0]);
    }

    public StringLocalizationData[] getIgnoredStrings() {
        TableItem[] items;
        ArrayList<StringLocalizationData> result = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object object = item.getData();
            if (item.getChecked() && item.getGrayed() && object instanceof StringLocalizationData) {
                result.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return result.toArray(new StringLocalizationData[0]);
    }

    public boolean isPageComplete() {
        return this.getExternalizedStrings().length > 0 || this.getIgnoredStrings().length > 0;
    }

    private void createTableSection(Composite _parent) {
        GridData gridData = null;
        Label label1 = new Label(_parent, 0);
        label1.setText(MTJUIMessages.StringLocalizationWizardPage1_tableLabel);
        gridData = new GridData(16384, 0x1000000, false, false);
        label1.setLayoutData((Object)gridData);
        final Button button1 = new Button(_parent, 32);
        button1.setText(MTJUIMessages.StringLocalizationWizardPage1_filterLabel);
        button1.setSelection(true);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StringLocalizationWizardPage1.this.updateStringsTable(button1.getSelection());
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        button1.setLayoutData((Object)gridData);
        this.createTableView(_parent);
    }

    private void createTableView(Composite _parent) {
        TableItem[] items;
        GridData gridData = null;
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        Composite tableParent = new Composite(_parent, 0);
        tableParent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableParent.setLayout((Layout)layout);
        this.table = new Table(tableParent, 67618);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StringLocalizationWizardPage1.this.showSourceString();
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tableLayout);
        int i = 0;
        while (i < COLUMNS.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(COLUMNS[i]);
            ++i;
        }
        this.viewer = new TableViewer(this.table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ClassFileStringsLabelProvider(this.buffer));
        this.viewer.setContentProvider((IContentProvider)new ClassFileStringsContentProvider());
        this.viewer.setColumnProperties(COLUMNS);
        this.updateStringsTable(true);
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(true);
            ++n2;
        }
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table)};
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new StringLocalizationCellModifier());
        gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 3;
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        Button button1 = new Button(tableParent, 0);
        button1.setText(MTJUIMessages.StringLocalizationWizardPage1_externalizeButtonText);
        gridData = new GridData(4, 128, false, false);
        button1.setLayoutData((Object)gridData);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = StringLocalizationWizardPage1.this.table.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(true);
                    item.setGrayed(false);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        Button button2 = new Button(tableParent, 0);
        button2.setText(MTJUIMessages.StringLocalizationWizardPage1_internalizeButtonText);
        gridData = new GridData(4, 128, false, false);
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = StringLocalizationWizardPage1.this.table.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        Button button3 = new Button(tableParent, 0);
        button3.setText(MTJUIMessages.StringLocalizationWizardPage1_ignoreButtonText);
        gridData = new GridData(4, 128, false, false);
        button3.setLayoutData((Object)gridData);
        button3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = StringLocalizationWizardPage1.this.table.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(true);
                    item.setGrayed(true);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void updateStringsTable(boolean filterIgnored) {
        ArrayList<StringLocalizationData> data = new ArrayList<StringLocalizationData>();
        IRegion[] regions = this.externalizer.externalize(this.buffer, !filterIgnored);
        int i = 0;
        while (i < regions.length) {
            String value = this.buffer.getText(regions[i].getOffset(), regions[i].getLength());
            data.add(new StringLocalizationData(regions[i], NLS.bind((String)"key_{0}", (Object)String.valueOf(i)), value.replaceAll("\"", "")));
            ++i;
        }
        if (data.size() == 0) {
            this.setMessage(MTJUIMessages.StringLocalizationWizardPage1_noStringsToLocalize, 2);
        } else {
            this.setMessage(MTJUIMessages.StringLocalizationWizardPage1_pageText);
        }
        this.viewer.setInput((Object)data.toArray(new StringLocalizationData[0]));
    }

    private void showSourceString() {
        if (this.buffer == null) {
            return;
        }
        StringLocalizationData[] data = this.getSelectedData();
        if (data != null && data.length > 0) {
            IRegion region = data[0].getRegion();
            this.text.setSelection(region.getOffset(), region.getOffset() + region.getLength());
            this.text.showSelection();
        }
    }

    private StringLocalizationData[] getSelectedData() {
        TableItem[] items;
        ArrayList<StringLocalizationData> result = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray = items = this.table.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object object = item.getData();
            if (object instanceof StringLocalizationData) {
                result.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return result.toArray(new StringLocalizationData[0]);
    }

    private void createSourceSection(Composite _parent) {
        GridData gridData = null;
        Label label1 = new Label(_parent, 0);
        label1.setText(MTJUIMessages.StringLocalizationWizardPage1_context);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        label1.setLayoutData((Object)gridData);
        this.text = new Text(_parent, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.text.setLayoutData((Object)gridData);
        this.text.setEditable(false);
        if (this.buffer != null) {
            this.text.setText(this.buffer.getContents());
        }
    }

    private class StringLocalizationCellModifier
    implements ICellModifier {
        private StringLocalizationCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(COLUMNS[1]);
        }

        public Object getValue(Object element, String property) {
            String result = null;
            if (element instanceof StringLocalizationData) {
                StringLocalizationData data = (StringLocalizationData)element;
                if (property.equals(COLUMNS[1])) {
                    result = data.getKey();
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            StringLocalizationData data = null;
            if (element instanceof StringLocalizationData) {
                data = (StringLocalizationData)element;
            } else if (element instanceof Item) {
                data = (StringLocalizationData)((Item)element).getData();
            }
            if (data != null && property.equals(COLUMNS[1])) {
                data.setKey((String)value);
                StringLocalizationWizardPage1.this.viewer.refresh();
            }
        }
    }
}

