/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.libraries;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LibraryInfoBlock
implements ISelectionChangedListener {
    private Device device;
    private String fontName;
    private int height;
    private Composite libraryInfoComposite;

    public Control createControl(Composite parent) {
        if (parent == null) {
            return null;
        }
        this.libraryInfoComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.libraryInfoComposite.setLayout((Layout)gridLayout);
        this.libraryInfoComposite.setLayoutData((Object)gridData);
        this.libraryInfoComposite.setData(null);
        this.device = this.libraryInfoComposite.getFont().getDevice();
        this.fontName = this.libraryInfoComposite.getFont().getFontData()[0].getName();
        this.height = this.libraryInfoComposite.getFont().getFontData()[0].getHeight();
        return this.libraryInfoComposite;
    }

    public Control getControl() {
        return this.libraryInfoComposite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            this.handlePostSelectionChange((StructuredSelection)event.getSelection());
        } else {
            this.handlePostSelectionChange(StructuredSelection.EMPTY);
        }
    }

    private void createLinkItem(Composite parent, String topLabelText, String urlTextValue, Listener selectionListener) {
        Label libraryLicenseURILabel = new Label(parent, 1);
        libraryLicenseURILabel.setText(topLabelText);
        libraryLicenseURILabel.setFont(new Font(this.device, this.fontName, this.height, 1));
        Link libraryLicenseURI = new Link(parent, 1);
        libraryLicenseURI.setText(NLS.bind((String)MTJUIMessages.LibraryInfoBlock_libraryLicenseURI_href, (Object)urlTextValue));
        libraryLicenseURI.addListener(13, selectionListener);
    }

    private void createTextItem(Composite parent, String topLabelText, String textValue) {
        Label topLabel = new Label(parent, 1);
        topLabel.setText(topLabelText);
        topLabel.setFont(new Font(this.device, this.fontName, this.height, 1));
        Text textValueLabel = new Text(parent, 73);
        textValueLabel.setText(textValue);
    }

    private void handlePostSelectionChange(StructuredSelection selection) {
        if (this.libraryInfoComposite == null) {
            return;
        }
        Composite childComposite = (Composite)this.libraryInfoComposite.getData();
        if (childComposite != null && childComposite.getParent() != null) {
            childComposite.getParent().dispose();
        }
        PixelConverter converter = new PixelConverter((Control)this.libraryInfoComposite);
        ScrolledPageContent spc = new ScrolledPageContent(this.libraryInfoComposite, 512);
        spc.getVerticalBar().setIncrement(5);
        GridData gridData = new GridData(1808);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        spc.setLayoutData(gridData);
        childComposite = spc.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        childComposite.setLayout((Layout)tableWrapLayout);
        gridData = new GridData(1808);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        childComposite.setLayoutData((Object)gridData);
        this.libraryInfoComposite.setData((Object)childComposite);
        IExternalLibrary library = (IExternalLibrary)selection.getFirstElement();
        if (library != null) {
            this.createTextItem(childComposite, MTJUIMessages.LibraryInfoBlock_libraryNameLabel, library.getName());
            this.createTextItem(childComposite, MTJUIMessages.LibraryInfoBlock_libraryVersionLabel, library.getVersion().toString());
            this.createTextItem(childComposite, MTJUIMessages.LibraryInfoBlock_libraryDescriptionLabel, library.getDescription());
            this.createLinkItem(childComposite, MTJUIMessages.LibraryInfoBlock_libraryLicenseURILabel, library.getLicence().getUri().toASCIIString(), new Listener(){

                public void handleEvent(Event event) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.createTextItem(childComposite, MTJUIMessages.LibraryInfoBlock_protection_domain_label, library.getSecurity().getProtectionDomain().getProtectionDomainType().toString().toLowerCase());
            this.createTextItem(childComposite, MTJUIMessages.LibraryInfoBlock_permissions_label, library.getSecurity().getPermissionList().toString());
        }
        this.libraryInfoComposite.layout(true);
    }
}

