/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.midlet.page;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewMidletWizardPage
extends NewTypeWizardPage {
    public static final String PAGE_NAME = "NewMidletClass";
    private static final String SETTINGS_ADD_TO_JAD = "addToJad";
    private static final String SETTINGS_CONSTRUCTORS = "constructors";
    private static final String SETTINGS_UNIMPLEMENTED = "unimplemented";
    private Button addToJadButton;
    private Button constructorsButton;
    private Button unimplementedButton;

    public NewMidletWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(MTJUIMessages.NewMidletWizardPage_title);
        this.setDescription(MTJUIMessages.NewMidletWizardPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createAddToJADSelectionControl(composite, nColumns);
        boolean addToJad = true;
        boolean constructors = true;
        boolean unimplemented = true;
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            addToJad = section.getBoolean(SETTINGS_ADD_TO_JAD);
            constructors = section.getBoolean(SETTINGS_CONSTRUCTORS);
            unimplemented = section.getBoolean(SETTINGS_UNIMPLEMENTED);
        }
        this.addToJadButton.setSelection(addToJad);
        this.constructorsButton.setSelection(constructors);
        this.unimplementedButton.setSelection(unimplemented);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.setSuperClass("javax.microedition.midlet.MIDlet", true);
    }

    public boolean isAddToJadSelected() {
        return this.addToJadButton.getSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private void createAddToJADSelectionControl(Composite parent, int numColumns) {
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        composite.setLayoutData((Object)gridData);
        this.addToJadButton = new Button(composite, 32);
        this.addToJadButton.setText(MTJUIMessages.NewMidletWizardPage_add_to_jad_btn_text);
    }

    private void createMethodStubSelectionControls(Composite parent, int numColumns) {
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        composite.setLayoutData((Object)gridData);
        Label l = new Label(composite, 0);
        l.setText(MTJUIMessages.NewMidletWizardPage_which_methods);
        this.constructorsButton = new Button(composite, 32);
        this.constructorsButton.setText(MTJUIMessages.NewMidletWizardPage_super_const);
        this.constructorsButton.setSelection(true);
        this.unimplementedButton = new Button(composite, 32);
        this.unimplementedButton.setText(MTJUIMessages.NewMidletWizardPage_unimplemented);
        this.unimplementedButton.setSelection(true);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    private IProject getContainedProject() {
        IProject prj = null;
        String str = this.getPackageFragmentRootText();
        Path path = new Path(str);
        IResource res = this.getWorkspaceRoot().findMember((IPath)path);
        if (res != null) {
            prj = res.getProject();
        }
        return prj;
    }

    protected IStatus containerChanged() {
        int resType;
        IStatus containerStatus = super.containerChanged();
        String str = this.getPackageFragmentRootText();
        Path path = new Path(str);
        IResource res = this.getWorkspaceRoot().findMember((IPath)path);
        if (res != null && ((resType = res.getType()) == 4 || resType == 2)) {
            IProject proj = res.getProject();
            try {
                if (!proj.hasNature("org.eclipse.mtj.core.nature") && res.exists()) {
                    if (resType == 4) {
                        return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotAMidletProject);
                    }
                    return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotInAMidletProject);
                }
            }
            catch (CoreException coreException) {
                return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotAMidletProject);
            }
        }
        return containerStatus;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, this.constructorsButton.getSelection(), this.unimplementedButton.getSelection(), imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IDialogSettings section = MTJUIPlugin.getDialogSettings(this.getDialogSettings(), PAGE_NAME);
        section.put(SETTINGS_ADD_TO_JAD, this.addToJadButton.getSelection());
        section.put(SETTINGS_CONSTRUCTORS, this.constructorsButton.getSelection());
        section.put(SETTINGS_UNIMPLEMENTED, this.unimplementedButton.getSelection());
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    protected IStatus superClassChanged() {
        IStatus superClassStatus = super.superClassChanged();
        boolean isMidlet = false;
        String sclassName = this.getSuperClass();
        IProject project = this.getContainedProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            if (javaProject != null) {
                isMidlet = Utils.isMidlet((IType)javaProject.findType(sclassName), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {}
        if (!isMidlet) {
            return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_super_must_be_midlet);
        }
        return superClassStatus;
    }
}

