/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.mtj.internal.ui.wizards.NewElementWizard;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageJavaSettings;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageLibrary;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private IConfigurationElement configElement;
    private NewMidletProjectWizardPageOne firstPage;
    private NewMidletProjectWizardPageProperties propertiesPage;
    private NewMidletProjectWizardPageLibrary libraryPage;
    private NewMidletProjectWizardPageJavaSettings javaSettingsPage;
    private IWorkbench workbench;

    public NewMidletProjectWizard() {
        this(null, null, null, null);
    }

    public NewMidletProjectWizard(NewMidletProjectWizardPageOne pageOne, NewMidletProjectWizardPageProperties pageTwo, NewMidletProjectWizardPageJavaSettings pageThree, NewMidletProjectWizardPageLibrary libraryPage) {
        ImageDescriptor descriptor = MTJUIPluginImages.DESC_NEW_PROJECT;
        this.setDefaultPageImageDescriptor(descriptor);
        this.setWindowTitle(MTJUIMessages.NewMidletProjectWizard_wizard_title);
        this.firstPage = pageOne;
        this.propertiesPage = pageTwo;
        this.javaSettingsPage = pageThree;
        this.libraryPage = libraryPage;
    }

    public void addPages() {
        if (this.firstPage == null) {
            this.firstPage = new NewMidletProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.firstPage);
        if (this.propertiesPage == null) {
            this.propertiesPage = new NewMidletProjectWizardPageProperties(this.firstPage);
        }
        this.addPage((IWizardPage)this.propertiesPage);
        if (this.libraryPage == null) {
            this.libraryPage = new NewMidletProjectWizardPageLibrary();
        }
        if (this.libraryPage.isPageDisplayable()) {
            this.addPage((IWizardPage)this.libraryPage);
        }
        if (this.javaSettingsPage == null) {
            this.javaSettingsPage = new NewMidletProjectWizardPageJavaSettings(this.firstPage, this.propertiesPage, this.libraryPage);
        }
        this.addPage((IWizardPage)this.javaSettingsPage);
        this.firstPage.init(this.getSelection(), this.getActivePart());
    }

    public void createControl(Composite parent) {
    }

    public IJavaElement getCreatedElement() {
        return this.javaSettingsPage.getJavaProject();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.workbench = workbench;
    }

    public boolean performCancel() {
        this.javaSettingsPage.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            try {
                IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.javaSettingsPage.getJavaProject());
                IFile jadfile = midletSuiteProject.getApplicationDescriptorFile();
                if (jadfile != null) {
                    BasicNewResourceWizard.selectAndReveal((IResource)jadfile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
                    this.openResource(jadfile);
                }
                MTJBuildProperties buildProperties = MTJBuildProperties.getBuildProperties((IMTJProject)midletSuiteProject);
                buildProperties.store();
            }
            catch (Throwable e) {
                MTJLogger.log((int)4, (String)MTJUIMessages.NewMidletProjectWizard_error_open_jad_file, (Throwable)e.getCause());
            }
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.javaSettingsPage.performFinish(monitor);
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = MTJUIMessages.NewMidletProjectWizard_error_create_project_window_title;
        String message = MTJUIMessages.NewMidletProjectWizard_error_create_project_window_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }
}

