/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageLibrary;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMidletProjectWizardPageJavaSettings
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_CLASSPATH = ".classpath";
    private static final String FILENAME_PROJECT = ".project";
    public Boolean isAutobuild;
    private IProject currProject = null;
    private URI currProjectLocation = null;
    private File fDotClasspathBackup;
    private File fDotProjectBackup;
    private NewMidletProjectWizardPageOne firstPage;
    private NewMidletProjectWizardPageProperties propertiesPage;
    private HashSet<IFileStore> fOrginalFolders;
    private boolean keepContent;
    private NewMidletProjectWizardPageLibrary pageLibrary;

    private static URI getRealLocation(String projectName, URI location) {
        if (location == null) {
            try {
                URI rootLocation = MTJCore.getWorkspace().getRoot().getLocationURI();
                location = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(projectName).toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Assert.isTrue((boolean)false, (String)"Can't happen");
            }
        }
        return location;
    }

    public NewMidletProjectWizardPageJavaSettings(NewMidletProjectWizardPageOne pageOne, NewMidletProjectWizardPageProperties pageTwo, NewMidletProjectWizardPageLibrary pageLibrary) {
        this.firstPage = pageOne;
        this.propertiesPage = pageTwo;
        this.pageLibrary = pageLibrary;
        this.isAutobuild = null;
    }

    public void performCancel() {
        if (this.currProject != null) {
            this.removeProvisonalProject();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_performFinish_monitor_taskname, 3);
            if (this.currProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.keepContent) {
                IJavaProject project = JavaCore.create((IProject)this.currProject);
                Map options = project.getOptions(false);
                project.setOptions(options);
            }
        }
        finally {
            monitor.done();
            this.currProject = null;
            if (this.isAutobuild != null) {
                IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                description.setAutoBuilding(this.isAutobuild.booleanValue());
                MTJCore.getWorkspace().setDescription(description);
                this.isAutobuild = null;
            }
        }
    }

    public void setVisible(boolean visible) {
        boolean isShownFirstTime;
        boolean bl = isShownFirstTime = visible && this.currProject == null;
        if (visible) {
            if (isShownFirstTime) {
                this.createProvisonalProject();
            }
        } else if (this.getContainer().getCurrentPage() == this.firstPage || this.getContainer().getCurrentPage() == this.pageLibrary) {
            this.removeProvisonalProject();
        }
        super.setVisible(visible);
        if (isShownFirstTime) {
            this.setFocus();
        }
    }

    public void updateConfiguration() {
        String projectName = this.firstPage.getProjectName();
        this.currProject = MTJCore.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)this.currProject);
        IPath projectPath = this.currProject.getFullPath();
        ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
        entryList.add(this.getSrcPathEntry(projectPath));
        this.addResourcesDirectoryIfRequested(entryList, this.currProject);
        Path entryPath = new Path("org.elipse.mtj.JavaMEContainer/" + this.firstPage.getSelectedDevice());
        entryList.add(JavaCore.newContainerEntry((IPath)entryPath));
        IClasspathEntry[] entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
        this.init(javaProject, null, entries, false);
    }

    private void addResourcesDirectoryIfRequested(List<IClasspathEntry> entryList, IProject project) {
        PreferenceAccessor prefs = PreferenceAccessor.instance;
        if (this.useSourceAndBinaryFolders() && prefs.getBoolean("use_resources_dir")) {
            String resDirName = prefs.getString("resources_dir");
            IFolder resFolder = project.getFolder(resDirName);
            if (!resFolder.exists()) {
                try {
                    resFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            entryList.add(JavaCore.newSourceEntry((IPath)resFolder.getFullPath()));
        }
    }

    private IStatus changeToNewProject() {
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (NewMidletProjectWizardPageJavaSettings.this.isAutobuild == null) {
                            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                            NewMidletProjectWizardPageJavaSettings.this.isAutobuild = description.isAutoBuilding();
                            description.setAutoBuilding(false);
                            MTJCore.getWorkspace().setDescription(description);
                        }
                        this.infoStatus = NewMidletProjectWizardPageJavaSettings.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.infoStatus;
        }
        catch (InvocationTargetException e) {
            String title = MTJUIMessages.NewMidletProjectWizardPageThree_changeToNewProject_errordialog_title;
            String message = MTJUIMessages.NewMidletProjectWizardPageThree_changeToNewProject_errordialog_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, String.valueOf(MTJUIMessages.NewMidletProjectWizardPageThree_createBackup_error_1) + name + MTJUIMessages.NewMidletProjectWizardPageThree_createBackup_error_2, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.currProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_doRemoveProject_taskname, 3);
        try {
            try {
                try {
                    boolean removeContent;
                    URI projLoc = this.currProject.getLocationURI();
                    boolean bl2 = removeContent = !this.keepContent && this.currProject.isSynchronized(2);
                    if (!removeContent && this.currProject.getProject().getFullPath().toFile().exists()) {
                        this.restoreExistingFolders(projLoc);
                    }
                    this.currProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    MidletSuiteFactory.removeMidletSuiteProject((IJavaProject)this.getJavaProject());
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                    description.setAutoBuilding(this.isAutobuild.booleanValue());
                    MTJCore.getWorkspace().setDescription(description);
                    this.isAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.currProject = null;
            this.keepContent = false;
        }
    }

    private IPath getSrcPath(IPath projectPath) {
        IPath srcPath = projectPath;
        if (this.useSourceAndBinaryFolders()) {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String srcPathName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
            srcPath = projectPath.append(srcPathName);
        }
        return srcPath;
    }

    private IClasspathEntry getSrcPathEntry(IPath projectPath) {
        IPath srcPath = this.getSrcPath(projectPath);
        IPath[] exclusions = null;
        exclusions = srcPath.equals((Object)projectPath) ? new IPath[]{new Path(String.valueOf(MTJCore.getDeploymentDirectoryName()) + "/"), new Path(".mtj.tmp/"), new Path(".processed/")} : new IPath[]{};
        return JavaCore.newSourceEntry((IPath)srcPath, (IPath[])exclusions);
    }

    private boolean hasExistingContent(URI realLocation) throws CoreException {
        IFileStore file = EFS.getStore((URI)realLocation);
        return file.fetchInfo().exists();
    }

    private void rememberExisitingFolders(URI projectLocation) {
        this.fOrginalFolders = new HashSet();
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !this.fOrginalFolders.contains(child.getName())) {
                    this.fOrginalFolders.add(child);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            String title = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_title;
            String message = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, MTJUIMessages.NewMidletProjectWizardPageThree_restoreExistingFiles_problem_restoring_dotproject, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
            classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, MTJUIMessages.NewMidletProjectWizardPageThree_restoreExistingFiles_problem_restoring_dotclasspath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void restoreExistingFolders(URI projectLocation) {
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !this.fOrginalFolders.contains(child)) {
                    child.delete(0, null);
                    this.fOrginalFolders.remove(child);
                }
                ++n2;
            }
            Iterator<IFileStore> iterator = this.fOrginalFolders.iterator();
            while (iterator.hasNext()) {
                IFileStore fileStore;
                IFileStore deleted = fileStore = iterator.next();
                deleted.mkdir(0, null);
            }
        }
        catch (CoreException e) {
            String title = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_title;
            String message = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    private final IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IStatus result = Status.OK_STATUS;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_taskname, 7);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String projectName = this.firstPage.getProjectName();
                this.currProject = MTJCore.getWorkspace().getRoot().getProject(projectName);
                this.currProjectLocation = this.firstPage.getProjectLocationURI();
                URI realLocation = NewMidletProjectWizardPageJavaSettings.getRealLocation(projectName, this.currProjectLocation);
                this.keepContent = this.hasExistingContent(realLocation);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.keepContent) {
                    this.rememberExistingFiles(realLocation);
                    this.rememberExisitingFolders(realLocation);
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    JavaCapabilityConfigurationPage.createProject((IProject)this.currProject, (URI)this.firstPage.getProjectLocationURI(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IDevice device = this.firstPage.getSelectedDevice();
                    MTJRuntimeList configurations = this.firstPage.getConfigurations();
                    IMetaData metadata = MTJCore.createMetaData((IProject)this.currProject, (ProjectType)ProjectType.MIDLET_SUITE);
                    metadata.setMTJRuntimeList(configurations);
                    try {
                        metadata.saveMetaData();
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    this.updateConfiguration();
                    try {
                        IRunnableWithProgress progress = super.getRunnable();
                        progress.run(monitor);
                    }
                    catch (Throwable e) {
                        throw new CoreException((IStatus)new Status(567, "", e.getMessage()));
                    }
                    String jadFileName = this.firstPage.getJadFileName();
                    IJavaProject javaProject = super.getJavaProject();
                    MidletSuiteFactory.MidletSuiteCreationRunnable runnable = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)this.currProject, (IJavaProject)javaProject, (IMIDPDevice)((IMIDPDevice)device), (String)jadFileName);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("MIDlet-Name", this.propertiesPage.getMIDletName());
                    properties.put("MIDlet-Vendor", this.propertiesPage.getMIDletVendor());
                    properties.put("MIDlet-Version", this.propertiesPage.getMIDletVersion());
                    properties.put("MicroEdition-Configuration", this.propertiesPage.getMeConfiguration());
                    properties.put("MicroEdition-Profile", this.propertiesPage.getMeProfile());
                    runnable.setProperties(properties);
                    runnable.setPreprocessingEnable(this.propertiesPage.isPreprocessingEnabled());
                    boolean localizationEnabled = this.propertiesPage.isLocalizationEnabled();
                    runnable.setLocalizationEnabled(localizationEnabled);
                    if (localizationEnabled) {
                        runnable.setPropertiesFolderName(this.propertiesPage.getPropertiesFolderName());
                        runnable.setPackageName(this.propertiesPage.getPackageName());
                    }
                    runnable.setJMUnitSupport(this.propertiesPage.isJMUnitEnabled());
                    runnable.run(monitor);
                    IAdaptable[] adaptableElements = new IAdaptable[]{this.currProject};
                    IWorkingSet workingSet = this.firstPage.getWorkingSet();
                    if (workingSet != null) {
                        IAdaptable adaptable;
                        Vector<IAdaptable> list = new Vector<IAdaptable>();
                        IAdaptable[] iAdaptableArray = workingSet.getElements();
                        int n = iAdaptableArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            adaptable = iAdaptableArray[n2];
                            list.add(adaptable);
                            ++n2;
                        }
                        iAdaptableArray = workingSet.adaptElements(adaptableElements);
                        n = iAdaptableArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            adaptable = iAdaptableArray[n2];
                            list.add(adaptable);
                            ++n2;
                        }
                        IAdaptable[] newElements = new IAdaptable[list.size()];
                        workingSet.setElements(list.toArray(newElements));
                        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                        workingSetManager.addRecentWorkingSet(workingSet);
                    }
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 567) {
                        result = new Status(1, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_fail_read_metadata);
                        this.deleteProjectFile(realLocation);
                        if (this.currProject.exists()) {
                            this.currProject.delete(true, null);
                        }
                        NewMidletProjectWizardPageJavaSettings.createProject((IProject)this.currProject, (URI)this.currProjectLocation, null);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.initializeBuildPath(JavaCore.create((IProject)this.currProject), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            }
            catch (Exception exception) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private boolean useSourceAndBinaryFolders() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        return store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
    }

    protected IProject createProvisonalProject() {
        IStatus status = this.changeToNewProject();
        if (status != null && !status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"createProvisonalProject", null, (IStatus)status);
        }
        return this.currProject;
    }

    protected void initializeBuildPath(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_monitor_buildpath_name, 2);
        try {
            IFolder folder;
            IClasspathEntry[] entries = null;
            IProject project = javaProject.getProject();
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            IWorkspaceRoot root = project.getWorkspace().getRoot();
            IClasspathEntry sourceClasspathEntry = this.getSrcPathEntry(project.getFullPath());
            if (sourceClasspathEntry.getPath() != project.getFullPath() && !(folder = root.getFolder(sourceClasspathEntry.getPath())).exists()) {
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            cpEntries.add(sourceClasspathEntry);
            this.addResourcesDirectoryIfRequested(cpEntries, project);
            Path entryPath = new Path("org.elipse.mtj.JavaMEContainer/" + this.firstPage.getSelectedDevice());
            cpEntries.add(JavaCore.newContainerEntry((IPath)entryPath));
            if (this.pageLibrary != null) {
                List<IPath> list = this.pageLibrary.getSelectedLibraries();
                if (this.propertiesPage.isJMUnitEnabled()) {
                    String libName = "JMUnit for CLDC 1.1";
                    IExternalLibrary jmunitLibrary = ExternalLibraryManager.getInstance().getMidletLibrary(libName);
                    if (jmunitLibrary == null) {
                        String message = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)libName);
                        MTJStatusHandler.throwCoreException((int)4, (int)-999, (String)message);
                    }
                    Path path = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + libName);
                    list.add((IPath)path);
                }
                for (IPath path : list) {
                    cpEntries.add(JavaCore.newContainerEntry((IPath)path, (boolean)true));
                }
            }
            entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(javaProject, this.getOutputLocation(), entries, true);
        }
        finally {
            monitor.done();
        }
    }

    protected void removeProvisonalProject() {
        if (!this.currProject.exists()) {
            this.currProject = null;
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NewMidletProjectWizardPageJavaSettings.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_errordialog_title;
            String message = MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_errordialog_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected final boolean useNewSourcePage() {
        return true;
    }
}

