/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.configurations.ConfigManageComponent;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.ComboButtonDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IComboButtonAdapter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class NewMidletProjectWizardPageOne
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageOne";
    private final ConfigurationGroup configurationGroup;
    private final JadNameGroup jadNameGroup;
    private final LocationGroup projectLocationGroup;
    private final ProjectNameGroup projectNameGroup;
    private final Validator wizardPageValidator;
    private final WorkingSetGroup workingSetGroup;

    public NewMidletProjectWizardPageOne() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(MTJUIMessages.NewMidletProjectWizardPageOne_title);
        this.setDescription(MTJUIMessages.NewMidletProjectWizardPageOne_description);
        this.projectNameGroup = new ProjectNameGroup();
        this.jadNameGroup = new JadNameGroup();
        this.projectLocationGroup = new LocationGroup();
        this.workingSetGroup = new WorkingSetGroup();
        this.configurationGroup = new ConfigurationGroup();
        this.projectNameGroup.addObserver(this.projectLocationGroup);
        this.projectNameGroup.addObserver(this.jadNameGroup);
        this.projectNameGroup.notifyObservers();
        this.wizardPageValidator = new Validator();
        this.projectNameGroup.addObserver(this.wizardPageValidator);
        this.configurationGroup.addObserver(this.wizardPageValidator);
        this.projectLocationGroup.addObserver(this.wizardPageValidator);
        this.jadNameGroup.addObserver(this.wizardPageValidator);
        this.workingSetGroup.addObserver(this.wizardPageValidator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        JavaRuntime.getDefaultVMInstall();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        Control nameControl = this.createNameControl(composite);
        nameControl.setLayoutData((Object)new GridData(768));
        Control jadControl = this.createJadNameControl(composite);
        jadControl.setLayoutData((Object)new GridData(768));
        Control locationControl = this.createLocationControl(composite);
        locationControl.setLayoutData((Object)new GridData(768));
        Control configControl = this.createConfigGroupControl(composite);
        configControl.setLayoutData((Object)new GridData(768));
        Control workingSets = this.createWorkingSets(composite);
        workingSets.setLayoutData((Object)new GridData(768));
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        this.setControl((Control)scrolledComposite);
    }

    public void dispose() {
        super.dispose();
        this.configurationGroup.dispose();
    }

    public MTJRuntimeList getConfigurations() {
        return this.configurationGroup.getConfigurations();
    }

    public IClasspathEntry[] getDefaultClasspathEntries() {
        Path entryPath = new Path("org.elipse.mtj.JavaMEContainer/" + this.getSelectedDevice());
        return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)entryPath)};
    }

    public String getJadFileName() {
        return this.jadNameGroup.getJadFileName();
    }

    public IPath getOutputLocation() {
        IPath outputLocationPath = new Path(this.getProjectName()).makeAbsolute();
        Path binPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        if (binPath.segmentCount() > 0) {
            outputLocationPath = outputLocationPath.append((IPath)binPath);
        }
        return outputLocationPath;
    }

    public URI getProjectLocationURI() {
        if (this.projectLocationGroup.isLocationInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.projectLocationGroup.getLocation());
    }

    public String getProjectName() {
        return this.projectNameGroup.getName();
    }

    public Observable getProjectNameGroup() {
        return this.projectNameGroup;
    }

    public Observable getConfigurationGroup() {
        return this.configurationGroup;
    }

    public IDevice getSelectedDevice() {
        return this.configurationGroup.getSelectedDevice();
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        IPath sourceFolderPath = new Path(this.getProjectName()).makeAbsolute();
        Path srcPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
        if (srcPath.segmentCount() > 0) {
            sourceFolderPath = sourceFolderPath.append((IPath)srcPath);
        }
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)sourceFolderPath)};
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
    }

    public void setProjectLocationURI(URI uri) {
        IPath path = uri != null ? URIUtil.toPath((URI)uri) : null;
        this.projectLocationGroup.setLocation(path);
    }

    public void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.projectNameGroup.setName(name);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameGroup.postSetFocus();
        }
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected Control createConfigGroupControl(Composite composite) {
        return this.configurationGroup.createControl(composite);
    }

    protected Control createJadNameControl(Composite composite) {
        return this.jadNameGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.projectLocationGroup.createControl(composite);
    }

    protected Control createNameControl(Composite composite) {
        return this.projectNameGroup.createControl(composite);
    }

    protected Control createWorkingSets(Composite composite) {
        return this.workingSetGroup.createControl(composite);
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetGroup.getWorkingSet();
    }

    protected void setControl(Control newControl) {
        Dialog.applyDialogFont((Control)newControl);
        super.setControl(newControl);
    }

    private final class ConfigurationGroup
    extends Observable {
        private ConfigManageComponent configManager;
        private IMTJRuntimeListChangeListener configurationsChangeListener;

        private ConfigurationGroup() {
        }

        public Control createControl(Composite parent) {
            Composite configComposite = new Composite(parent, 0);
            configComposite.setFont(parent.getFont());
            configComposite.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(1, false), false));
            this.configManager = new ConfigManageComponent();
            this.initConfigManager(configComposite);
            this.configurationsChangeListener = new IMTJRuntimeListChangeListener(){

                public void activeMTJRuntimeSwitched(SwitchActiveMTJRuntimeEvent event) {
                    ConfigurationGroup.this.fireEvent();
                }

                public void mtjRuntimeAdded(AddMTJRuntimeEvent event) {
                    MTJRuntimeList configurations = (MTJRuntimeList)event.getSource();
                    if (configurations.size() == 1) {
                        ConfigurationGroup.this.fireEvent();
                    }
                }

                public void mtjRuntimeRemoved(RemoveMTJRuntimeEvent event) {
                    MTJRuntimeList configurations = (MTJRuntimeList)event.getSource();
                    if (configurations.isEmpty()) {
                        ConfigurationGroup.this.fireEvent();
                    }
                }
            };
            this.configManager.setConfigurationsChangeListener(this.configurationsChangeListener);
            return configComposite;
        }

        public void dispose() {
            this.configManager.dispose();
        }

        public MTJRuntimeList getConfigurations() {
            return this.configManager.getConfigurations();
        }

        public IDevice getSelectedDevice() {
            MTJRuntime activeConfiguration = this.configManager.getActiveConfiguration();
            if (activeConfiguration == null) {
                return null;
            }
            return activeConfiguration.getDevice();
        }

        private void initConfigManager(Composite configComposite) {
            this.configManager.setDescription(MTJUIMessages.ConfigurationSection_Description);
            this.configManager.createContents(configComposite);
            IDevice defaultDevice = MTJCore.getDeviceRegistry().getDefaultDevice();
            if (defaultDevice == null) {
                return;
            }
            MTJRuntime defaultConfig = MTJRuntimeListUtils.createMTJRuntime((String)defaultDevice.getName());
            defaultConfig.setDevice(defaultDevice);
            defaultConfig.setSymbolSet(defaultDevice.getSymbolSet());
            this.configManager.getConfigurations().add(defaultConfig);
            this.configManager.getConfigurations().switchActiveMTJRuntime(defaultConfig);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class JadNameGroup
    extends Observable
    implements Observer,
    IDialogFieldListener {
        private String previousJadName;
        protected final StringDialogField jadFileNameField;
        protected final SelectionButtonDialogField projectBasedRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField userDefinedRadio;

        public JadNameGroup() {
            this.projectBasedRadio.setDialogFieldListener(this);
            this.projectBasedRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadNameGroup_projectBasedRadio);
            this.userDefinedRadio = new SelectionButtonDialogField(16);
            this.userDefinedRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadNameGroup_userDefinedRadio);
            this.jadFileNameField = new StringDialogField();
            this.jadFileNameField.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadFileNameField);
            this.jadFileNameField.setDialogFieldListener(this);
            this.userDefinedRadio.attachDialogField(this.jadFileNameField);
            this.projectBasedRadio.setSelection(true);
            this.userDefinedRadio.setSelection(false);
        }

        public Control createControl(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_jad_groupname);
            new Label((Composite)group, 0).setText(MTJUIMessages.NewMidletProjectWizardPageOne_jad_label);
            this.projectBasedRadio.doFillIntoGrid((Composite)group, 2);
            this.userDefinedRadio.doFillIntoGrid((Composite)group, 2);
            this.jadFileNameField.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.jadFileNameField.getTextControl(null));
            return group;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.projectBasedRadio) {
                boolean checked = this.projectBasedRadio.isSelected();
                if (checked) {
                    this.previousJadName = this.jadFileNameField.getText();
                    this.jadFileNameField.setText(String.valueOf(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()) + ".jad");
                } else {
                    this.jadFileNameField.setText(this.previousJadName);
                }
            }
            this.fireEvent();
        }

        public String getJadFileName() {
            return this.jadFileNameField.getText();
        }

        public boolean isProjectBasedRadioSelected() {
            return this.projectBasedRadio.isSelected();
        }

        public void postSetFocus() {
            this.jadFileNameField.postSetFocusOnDialogField(NewMidletProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setJadFileName(String name) {
            this.jadFileNameField.setText(name);
        }

        public void update(Observable o, Object arg) {
            if (this.isProjectBasedRadioSelected()) {
                this.setJadFileName(String.valueOf(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()) + ".jad");
            }
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.mtj.ui.last.external.project";
        private String fPreviousExternalLocation;
        protected final SelectionButtonDialogField externalLocationRadio;
        protected final StringButtonDialogField projectLocation;
        protected final SelectionButtonDialogField workspaceLocationRadio = new SelectionButtonDialogField(16);

        public LocationGroup() {
            this.workspaceLocationRadio.setDialogFieldListener(this);
            this.workspaceLocationRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_workspaceLocationRadio);
            this.externalLocationRadio = new SelectionButtonDialogField(16);
            this.externalLocationRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_externalLocationRadio);
            this.projectLocation = new StringButtonDialogField(this);
            this.projectLocation.setDialogFieldListener(this);
            this.projectLocation.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_projectLocation);
            this.projectLocation.setButtonLabel(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_browse_button);
            this.externalLocationRadio.attachDialogField(this.projectLocation);
            this.workspaceLocationRadio.setSelection(true);
            this.externalLocationRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(NewMidletProjectWizardPageOne.this.getShell());
            dialog.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_changeControlPressed_dialogMessage);
            String directoryName = this.projectLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = MTJUIPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.projectLocation.setText(selectedDirectory);
                MTJUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_contents);
            this.workspaceLocationRadio.doFillIntoGrid((Composite)group, 3);
            this.externalLocationRadio.doFillIntoGrid((Composite)group, 3);
            this.projectLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.projectLocation.getTextControl(null));
            return group;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.workspaceLocationRadio) {
                boolean checked = this.workspaceLocationRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.projectLocation.getText();
                    this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
                } else {
                    this.projectLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isWorkspaceRadioSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.projectLocation.getText().trim());
        }

        public boolean isLocationInWorkspace() {
            String location = NewMidletProjectWizardPageOne.this.projectLocationGroup.getLocation().toOSString();
            IPath projectPath = Path.fromOSString((String)location);
            return Platform.getLocation().isPrefixOf(projectPath);
        }

        public boolean isWorkspaceRadioSelected() {
            return this.workspaceLocationRadio.isSelected();
        }

        public void setLocation(IPath path) {
            this.workspaceLocationRadio.setSelection(path == null);
            if (path != null) {
                this.projectLocation.setText(path.toOSString());
            } else {
                this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
            }
            this.fireEvent();
        }

        public void update(Observable o, Object arg) {
            if (this.isWorkspaceRadioSelected()) {
                this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
            }
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }
    }

    public final class ProjectNameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField projNameField = new StringDialogField();

        public ProjectNameGroup() {
            this.projNameField.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup);
            this.projNameField.setDialogFieldListener(this);
        }

        public Control createControl(Composite composite) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), false));
            this.projNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.projNameField.getTextControl(null));
            return nameComposite;
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        public String getName() {
            return this.projNameField.getText().trim();
        }

        public void postSetFocus() {
            this.projNameField.postSetFocusOnDialogField(NewMidletProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.projNameField.setText(name);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus status;
            String location;
            IWorkspace workspace = MTJUIPlugin.getWorkspace();
            String name = NewMidletProjectWizardPageOne.this.projectNameGroup.getName();
            if (name.length() == 0) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(null);
                NewMidletProjectWizardPageOne.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_emptyName);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(nameStatus.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IProject handle = workspace.getRoot().getProject(name);
            if (handle.exists()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_alreadyExists);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath projectLocation = MTJCore.getWorkspace().getRoot().getLocation().append(name);
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    projectLocation = new Path(canonicalPath);
                }
                catch (IOException e) {
                    MTJLogger.log((int)4, (Throwable)e);
                }
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(NewMidletProjectWizardPageOne.this.projectNameGroup.getName())) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_alreadyExists);
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if ((location = NewMidletProjectWizardPageOne.this.projectLocationGroup.getLocation().toOSString()).length() == 0) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(null);
                NewMidletProjectWizardPageOne.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_missingLocation);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_invalidDirectory);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (NewMidletProjectWizardPageOne.this.projectLocationGroup.isWorkspaceRadioSelected()) {
                projectPath = projectPath.append(NewMidletProjectWizardPageOne.this.projectNameGroup.getName());
            }
            if (projectPath.toFile().exists()) {
                if (Platform.getLocation().isPrefixOf(projectPath)) {
                    if (!Platform.getLocation().equals((Object)projectPath.removeLastSegments(1))) {
                        NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_workspace1);
                        NewMidletProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                    if (!projectPath.toFile().exists()) {
                        NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_workspace2);
                        NewMidletProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                }
            } else if (!NewMidletProjectWizardPageOne.this.projectLocationGroup.isWorkspaceRadioSelected()) {
                if (!this.canCreate(projectPath.toFile())) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_failedCreateContents);
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
                IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
                if (!locationStatus.isOK()) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(locationStatus.getMessage());
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if (!(status = this.isValidJadName(NewMidletProjectWizardPageOne.this.jadNameGroup.getJadFileName())).isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(status.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            status = this.isValidConfigurations();
            if (!status.isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(status.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            if (NewMidletProjectWizardPageOne.this.workingSetGroup.isProjectAddedWorkingSet() && NewMidletProjectWizardPageOne.this.getWorkingSet() == null) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_workingSet_null);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            NewMidletProjectWizardPageOne.this.setPageComplete(true);
            NewMidletProjectWizardPageOne.this.setErrorMessage(null);
            NewMidletProjectWizardPageOne.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }

        private IStatus isValidConfigurations() {
            Status status = null;
            status = NewMidletProjectWizardPageOne.this.configurationGroup.getConfigurations().isEmpty() ? new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_devicecount_error) : new Status(0, "org.eclipse.mtj.ui", "");
            return status;
        }

        private IStatus isValidJadName(String jadName) {
            String jadFileName = jadName;
            IWorkspace workspace = MTJCore.getWorkspace();
            Status result = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_emptyname);
            if (jadFileName != null && jadFileName != "" && (result = workspace.validateName(jadFileName, 1)).isOK()) {
                if (!jadFileName.endsWith(".jad")) {
                    result = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_extension);
                } else if (jadFileName.equals(".jad")) {
                    result = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_emptyname);
                }
            }
            return result;
        }
    }

    private final class WorkingSetGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IComboButtonAdapter,
    IDialogFieldListener {
        private SelectionButtonDialogField addWorkingSetButton;
        private ComboButtonDialogField workingSetsSelection;
        private IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        private IWorkingSet workingSet;

        public WorkingSetGroup() {
            this.addWorkingSetButton = new SelectionButtonDialogField(32);
            this.addWorkingSetButton.setDialogFieldListener(this);
            this.addWorkingSetButton.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_workingSetsButton);
            this.workingSetsSelection = new ComboButtonDialogField(this, 8);
            this.workingSetsSelection.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_workingSetGroup_selection);
            this.workingSetsSelection.setButtonLabel(MTJUIMessages.NewMidletProjectWizardPageOne_workingSetGroup_select_button);
            IWorkingSet[] recentWorkingSets = this.workingSetManager.getRecentWorkingSets();
            String[] items = new String[recentWorkingSets.length];
            int i = 0;
            IWorkingSet[] iWorkingSetArray = recentWorkingSets;
            int n = recentWorkingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                items[i] = workingSet.getName();
                ++i;
                ++n2;
            }
            this.workingSetsSelection.setItems(items);
            this.workingSetsSelection.setDialogFieldListener(this);
            this.addWorkingSetButton.setSelection(false);
            this.addWorkingSetButton.attachDialogField(this.workingSetsSelection);
        }

        public void dialogFieldChanged(DialogField field) {
            String[] items;
            if (field == this.workingSetsSelection) {
                this.workingSet = this.workingSetManager.getWorkingSet(this.workingSetsSelection.getText());
            } else if (field == this.addWorkingSetButton && this.workingSetsSelection.getText().equals("") && (items = this.workingSetsSelection.getItems()).length > 0) {
                this.workingSetsSelection.setText(items[0]);
            }
            this.fireEvent();
        }

        public void changeControlPressed(DialogField field) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            IWorkingSetSelectionDialog workingSetWizard = this.workingSetManager.createWorkingSetSelectionDialog(shell, false);
            if (workingSetWizard != null && workingSetWizard.open() == 0) {
                this.workingSet = workingSetWizard.getSelection()[0];
                ArrayList<String> items = new ArrayList<String>(Arrays.asList(this.workingSetsSelection.getItems()));
                String workingSetName = this.workingSet.getName();
                items.add(workingSetName);
                this.workingSetsSelection.setItems(items.toArray(new String[items.size()]));
                this.workingSetsSelection.setText(workingSetName);
            }
            this.fireEvent();
        }

        public void update(Observable o, Object arg) {
            this.fireEvent();
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_workingSetGroup_contents);
            this.addWorkingSetButton.doFillIntoGrid((Composite)group, 3);
            this.workingSetsSelection.doFillIntoGrid((Composite)group, 3);
            return group;
        }

        public boolean isProjectAddedWorkingSet() {
            return this.addWorkingSetButton.isSelected();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public IWorkingSet getWorkingSet() {
            return this.workingSet;
        }
    }
}

