/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.device;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editors.device.pages.DeviceBasicEditorPage;
import org.eclipse.mtj.internal.ui.editors.device.pages.DeviceLibrariesEditorPage;
import org.eclipse.mtj.internal.ui.editors.device.pages.DeviceSymbolSetEditorPage;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DeviceEditorDialog
extends Dialog {
    private Label errorLabel;
    private TabFolder tabFolder;
    private AbstractDeviceEditorPage[] pages;
    private IDevice device;

    public DeviceEditorDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public DeviceEditorDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setDevice(IDevice device) {
        this.device = device;
        if (this.pages != null) {
            this.setDeviceOnPages((IMIDPDevice)device);
        }
    }

    private void handleException(String message, Throwable throwable) {
        MTJLogger.log((int)2, (String)MTJUIMessages.DeviceEditorDialog_error_saving_device_log_message, (Throwable)throwable);
        MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceEditorDialog_error_saving_device_title, message, throwable);
    }

    private void setDeviceOnPages(IMIDPDevice device) {
        AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages;
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDeviceEditorPage element = abstractDeviceEditorPageArray[n2];
            element.setDevice(device);
            ++n2;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages;
                int n = this.pages.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractDeviceEditorPage element = abstractDeviceEditorPageArray[n2];
                    element.commitDeviceChanges();
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.handleException(MTJUIMessages.DeviceEditorDialog_error_saving_device_message, e);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.device != null) {
            newShell.setText(MTJUIMessages.bind((String)MTJUIMessages.DeviceEditorDialog_edit_device1, (Object)this.device.getName()));
        } else {
            newShell.setText(MTJUIMessages.DeviceEditorDialog_edit_device2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.errorLabel = new Label(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages = new AbstractDeviceEditorPage[]{new DeviceBasicEditorPage((Composite)this.tabFolder, this.isJavaExecutableDevice(), 0), new DeviceLibrariesEditorPage((Composite)this.tabFolder, 0), new DeviceSymbolSetEditorPage((Composite)this.tabFolder, 0)};
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDeviceEditorPage page = abstractDeviceEditorPageArray[n2];
            page.setDialog(this);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setControl((Control)page);
            item.setText(page.getTitle());
            if (this.device != null) {
                page.setDevice((IMIDPDevice)this.device);
            }
            ++n2;
        }
        return composite;
    }

    protected boolean isJavaExecutableDevice() {
        return false;
    }

    void setErrorMessage(String message) {
        this.errorLabel.setText(message == null ? "" : message);
    }

    void updateCompletionState() {
        if (this.pages != null) {
            boolean complete = true;
            int i = 0;
            while (i < this.pages.length) {
                if (!this.pages[i].isValid()) {
                    complete = false;
                    break;
                }
                ++i;
            }
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(complete);
            }
        }
    }
}

