/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Version;

public class LibraryApiEditorDialog
extends Dialog {
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_identifier_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_version_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_type_columnInfo, 20.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_name_columnInfo, 50.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_IDENTIFIER = "identifier";
    private static final String PROP_NAME = "name";
    private static final String PROP_TYPE = "type";
    private static final String PROP_VERSION = "version";
    private static final String[] PROPERTIES = new String[]{"identifier", "version", "type", "name"};
    private List<IAPI> apis;
    private TableViewer viewer;

    public LibraryApiEditorDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public LibraryApiEditorDialog(Shell parentShell) {
        super(parentShell);
    }

    public IAPI[] getAPIs() {
        return this.apis == null ? null : this.apis.toArray(new IAPI[this.apis.size()]);
    }

    public void setAPIs(IAPI[] apis) {
        this.apis = new ArrayList<IAPI>();
        this.apis.addAll(Arrays.asList(apis));
    }

    private TableViewer createTableViewer(Composite composite) {
        String[] comboValues = new String[]{MIDPAPIType.CONFIGURATION.toString(), MIDPAPIType.PROFILE.toString(), MIDPAPIType.OPTIONAL.toString(), MIDPAPIType.UNKNOWN.toString()};
        int styles = 68098;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new LibraryApiContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new APILabelProvider());
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings("librayApiViewerSettings");
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 650, COLUMN_INFO, 0);
        viewerConfiguration.configure(viewer);
        viewer.setCellModifier((ICellModifier)new CellModifier());
        viewer.setColumnProperties(PROPERTIES);
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, comboValues), new TextCellEditor((Composite)table)});
        viewer.setInput(new Object());
        return viewer;
    }

    private IAPI getSelectedAPI() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (IAPI)selection.getFirstElement();
    }

    private void handleAddButton() {
        MIDPAPI newApi = new MIDPAPI();
        this.apis.add((IAPI)newApi);
        this.viewer.refresh();
    }

    private void handleRemoveButton() {
        IAPI selected = this.getSelectedAPI();
        if (selected != null) {
            this.apis.remove(selected);
            this.viewer.refresh();
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.apis = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = MTJUIMessages.LibraryApiEditorDialog_title;
        newShell.setText(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(composite);
        this.viewer.getTable().setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        buttonComposite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(MTJUIMessages.LibraryApiEditorDialog_addButton_label_text);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryApiEditorDialog.this.handleAddButton();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(MTJUIMessages.LibraryApiEditorDialog_removeButton_label_text);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryApiEditorDialog.this.handleRemoveButton();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IAPI api = LibraryApiEditorDialog.this.getSelectedAPI();
                removeButton.setEnabled(api != null);
            }
        });
        return composite;
    }

    private static class APILabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private APILabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IMIDPAPI api = (IMIDPAPI)element;
            String text = "";
            switch (columnIndex) {
                case 0: {
                    text = api.getIdentifier();
                    break;
                }
                case 1: {
                    text = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{api.getVersion().getMajor(), api.getVersion().getMinor()});
                    break;
                }
                case 2: {
                    text = api.getType().toString();
                    break;
                }
                case 3: {
                    text = api.getName();
                }
            }
            return text;
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            IMIDPAPI api = (IMIDPAPI)element;
            switch (this.getColumnIndex(property)) {
                case 0: {
                    value = api.getIdentifier();
                    break;
                }
                case 1: {
                    value = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{api.getVersion().getMajor(), api.getVersion().getMinor()});
                    break;
                }
                case 2: {
                    value = api.getType().getTypecode();
                    break;
                }
                case 3: {
                    value = api.getName();
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            IMIDPAPI api = (IMIDPAPI)item.getData();
            switch (this.getColumnIndex(property)) {
                case 0: {
                    api.setIdentifier((String)value);
                    break;
                }
                case 1: {
                    api.setVersion(new Version((String)value));
                    break;
                }
                case 2: {
                    Integer integerCode = (Integer)value;
                    api.setType(MIDPAPIType.getMIDPAPITypeByCode((int)integerCode));
                    break;
                }
                case 3: {
                    api.setName((String)value);
                }
            }
            LibraryApiEditorDialog.this.viewer.refresh((Object)api, true);
        }

        private int getColumnIndex(String property) {
            int index = -1;
            int i = 0;
            while (i < PROPERTIES.length) {
                if (PROPERTIES[i].equals(property)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
    }

    private class LibraryApiContentProvider
    implements IStructuredContentProvider {
        private LibraryApiContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = NO_ELEMENTS;
            if (LibraryApiEditorDialog.this.apis != null) {
                elements = LibraryApiEditorDialog.this.apis.toArray(new IAPI[LibraryApiEditorDialog.this.apis.size()]);
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

