/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractJADEditorPage
extends FormPage
implements IHyperlinkListener {
    private boolean dirty;
    private JADFormEditor editor;
    private IJavaProject javaProject;
    IMessageManager errorMessageManager;

    public AbstractJADEditorPage(JADFormEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
        this.editor = editor;
        this.javaProject = JavaCore.create((IProject)editor.getJadFile().getProject());
    }

    public AbstractJADEditorPage(String id) {
        this(id, id);
    }

    public AbstractJADEditorPage(String id, String title) {
        super(id, title);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSaveAs() {
    }

    public void editorDirtyStateChanged() {
        this.editor.editorDirtyStateChanged();
    }

    public abstract void editorInputChanged();

    public IMessageManager getErrorMessageManager() {
        return this.errorMessageManager;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public abstract String getTitle();

    public void initialize(FormEditor editor) {
        super.initialize(editor);
        this.editor = (JADFormEditor)editor;
        this.javaProject = JavaCore.create((IProject)this.editor.getJadFile().getProject());
    }

    public boolean isDirty() {
        return this.dirty || this.getPreferenceStore().needsSaving() || super.isDirty();
    }

    public abstract boolean isManagingProperty(String var1);

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void linkActivated(HyperlinkEvent e) {
    }

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
    }

    private Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    protected void configureFormText(final Form form, FormText text) {
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String is = (String)e.getHref();
                try {
                    int index = Integer.parseInt(is);
                    IMessage[] messages = form.getChildrenMessages();
                    IMessage message = messages[index];
                    Control c = message.getControl();
                    ((FormText)e.widget).getShell().dispose();
                    if (c != null) {
                        c.setFocus();
                    }
                }
                catch (Throwable throwable) {
                    ((FormText)e.widget).getShell().dispose();
                }
            }
        });
        text.setImage("error", this.getImage(3));
        text.setImage("warning", this.getImage(2));
        text.setImage("info", this.getImage(1));
    }

    protected final FormText createClient(Composite section, String content, FormToolkit toolkit, IHyperlinkListener listener) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        text.addHyperlinkListener(listener);
        return text;
    }

    protected void createErrorMessageHandler(IManagedForm managedForm) {
        this.errorMessageManager = managedForm.getMessageManager();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
    }

    protected final Section createStaticBasicSection(FormToolkit toolkit, Composite parent, String text, String description) {
        Section section = toolkit.createSection(parent, 384);
        section.setText(text);
        section.setDescription(description);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected final Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(text);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected Composite createStaticSectionClient(FormToolkit toolkit, Composite parent, String sectionId) {
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        container.setData((Object)sectionId);
        TableWrapData data = new TableWrapData(256);
        container.setLayoutData((Object)data);
        return container;
    }

    protected abstract String getHelpResource();

    protected IManifestPreferenceStore getPreferenceStore() {
        return this.editor.getPreferenceStore();
    }
}

