/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.ListDescriptorPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class JADPropertiesEditorPage
extends AbstractJADEditorPage
implements IPropertyChangeListener {
    private Constructor<?> comboEditorConstructor;
    private Class<?> comboFieldEditorClass;
    private DescriptorPropertyDescription[] descriptors;
    protected FieldEditor[] fieldEditors;

    public JADPropertiesEditorPage(JADFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public JADPropertiesEditorPage(String id, String title) {
        super(id, title);
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        FieldEditor[] fieldEditorArray = this.fieldEditors;
        int n = this.fieldEditors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor element = fieldEditorArray[n2];
            element.store();
            ++n2;
        }
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.updateEditComponents();
    }

    public DescriptorPropertyDescription[] getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.doGetDescriptors();
        }
        return this.descriptors;
    }

    public boolean isManagingProperty(String property) {
        boolean manages = false;
        int i = 0;
        while (i < this.getDescriptors().length) {
            DescriptorPropertyDescription desc = this.getDescriptors()[i];
            if (property.equals(desc.getPropertyName())) {
                manages = true;
                break;
            }
            ++i;
        }
        return manages;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            this.setDirty(true);
        }
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    protected FieldEditor createComboFieldEditor(FormToolkit toolkit, Composite composite, DescriptorPropertyDescription description) {
        if (this.comboFieldEditorClass == null) {
            this.initializeComboFieldEditorSupport();
        }
        ListDescriptorPropertyDescription listDescription = (ListDescriptorPropertyDescription)description;
        FieldEditor editor = null;
        try {
            editor = (FieldEditor)this.comboEditorConstructor.newInstance(new Object[]{listDescription.getPropertyName(), listDescription.getDisplayName(), listDescription.getNamesAndValues(), composite});
        }
        catch (IllegalArgumentException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (InstantiationException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        return editor;
    }

    protected IntegerFieldEditor createIntegerFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        IntegerFieldEditor integerEditor = new IntegerFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)integerEditor.getTextControl(parent), true, true);
        return integerEditor;
    }

    protected ExtendedStringFieldEditor createStringFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        ExtendedStringFieldEditor editor = new ExtendedStringFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)editor.getTextControl(parent), true, true);
        return editor;
    }

    private void initializeComboFieldEditorSupport() {
        String[] names = new String[]{"org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor", "org.eclipse.jface.preference.ComboFieldEditor"};
        int i = 0;
        while (this.comboFieldEditorClass == null && i < names.length) {
            String name = names[i];
            try {
                this.comboFieldEditorClass = Class.forName(name);
                this.comboEditorConstructor = this.comboFieldEditorClass.getConstructors()[0];
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
            ++i;
        }
    }

    protected void updateEditComponents() {
        if (this.fieldEditors != null) {
            IManifestPreferenceStore store = this.getPreferenceStore();
            FieldEditor[] fieldEditorArray = this.fieldEditors;
            int n = this.fieldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                FieldEditor fieldEditor = fieldEditorArray[n2];
                fieldEditor.setPreferenceStore((IPreferenceStore)store);
                fieldEditor.load();
                ++n2;
            }
        }
    }

    protected abstract void addContextHelp(Composite var1);

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 1));
        Composite center = toolkit.createComposite(body);
        center.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        center.setLayoutData((Object)new TableWrapData(256));
        Section section = this.createStaticBasicSection(toolkit, center, this.getSectionTitle(), this.getSectionDescription());
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    protected void createSectionContent(IManagedForm managedForm, Composite composite, IPropertyChangeListener propertyChangeListener) {
        Control[] children;
        FormToolkit toolkit = managedForm.getToolkit();
        composite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        new Label(composite, 0);
        new Label(composite, 0);
        DescriptorPropertyDescription[] theDescriptors = this.getDescriptors();
        this.fieldEditors = new FieldEditor[theDescriptors.length];
        int i = 0;
        while (i < theDescriptors.length) {
            switch (theDescriptors[i].getDataType()) {
                case 3: {
                    this.fieldEditors[i] = this.createIntegerFieldEditor(toolkit, composite, theDescriptors[i]);
                    break;
                }
                case 4: {
                    this.fieldEditors[i] = this.createComboFieldEditor(toolkit, composite, theDescriptors[i]);
                    break;
                }
                default: {
                    this.fieldEditors[i] = this.createStringFieldEditor(toolkit, composite, theDescriptors[i]);
                }
            }
            Label label = this.fieldEditors[i].getLabelControl(composite);
            toolkit.adapt((Control)label, false, false);
            this.fieldEditors[i].setPropertyChangeListener(propertyChangeListener);
            ++i;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Combo) {
                toolkit.adapt(control, false, false);
            }
            ++n2;
        }
        this.updateEditComponents();
        this.addContextHelp(composite);
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        return JADAttributesRegistry.getJADAttrDescriptorsByPage((String)this.getId());
    }

    protected abstract String getSectionDescription();

    protected abstract String getSectionTitle();

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.updateEditComponents();
        this.setDirty(false);
    }
}

