/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.service;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcOperation;
import org.eclipse.mylyn.internal.bugzilla.core.service.XmlRpcClassCastException;
import org.eclipse.mylyn.internal.commons.xmlrpc.CommonXmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaXmlRpcClient
extends CommonXmlRpcClient {
    public static final String XML_BUGZILLA_VERSION = "Bugzilla.version";
    public static final String XML_BUGZILLA_TIME = "Bugzilla.time";
    public static final String XML_USER_LOGIN = "User.login";
    public static final String XML_USER_GET = "User.get";
    public static final String XML_BUG_FIELDS = "Bug.fields";
    public static final String XML_PRODUCT_GET_SELECTABLE = "Product.get_selectable_products";
    public static final String XML_PRODUCT_GET_ENTERABLE = "Product.get_enterable_products";
    public static final String XML_PRODUCT_GET_ACCESSIBLE = "Product.get_accessible_products";
    public static final String XML_PRODUCT_GET = "Product.get";
    public static final String XML_PARAMETER_LOGIN = "login";
    public static final String XML_PARAMETER_PASSWORD = "password";
    public static final String XML_PARAMETER_REMEMBER = "remember";
    public static final String XML_PARAMETER_IDS = "ids";
    public static final String XML_PARAMETER_NAMES = "names";
    public static final String XML_PARAMETER_MATCH = "match";
    public static final String XML_RESPONSE_DB_TIME = "db_time";
    public static final String XML_RESPONSE_WEB_TIME = "web_time";
    public static final String[] XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE = new String[]{"tz_offset", "tz_short_name", "web_time_utc", "tz_name"};
    public static final String XML_RESPONSE_VERSION = "version";
    public static final String XML_RESPONSE_USERS = "users";
    public static final String XML_RESPONSE_ID = "id";
    public static final String XML_RESPONSE_IDS = "ids";
    public static final String XML_RESPONSE_FIELDS = "fields";
    public static final String XML_RESPONSE_PRODUCTS = "products";
    private int userID = -1;

    public BugzillaXmlRpcClient(AbstractWebLocation location, HttpClient client) {
        super(location, client);
    }

    public BugzillaXmlRpcClient(AbstractWebLocation location) {
        super(location);
    }

    public String getVersion() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<String>((CommonXmlRpcClient)this){

            public String execute() throws XmlRpcException {
                String result = "";
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_BUGZILLA_VERSION, null);
                result = BugzillaXmlRpcClient.this.response2String(response, BugzillaXmlRpcClient.XML_RESPONSE_VERSION);
                return result;
            }
        }.execute();
    }

    public Date getDBTime() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Date>((CommonXmlRpcClient)this){

            public Date execute() throws XmlRpcException {
                Date result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                result = BugzillaXmlRpcClient.this.response2Date(response, BugzillaXmlRpcClient.XML_RESPONSE_DB_TIME);
                return result;
            }
        }.execute();
    }

    public Date getWebTime() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Date>((CommonXmlRpcClient)this){

            public Date execute() throws XmlRpcException {
                Date result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                result = BugzillaXmlRpcClient.this.response2Date(response, BugzillaXmlRpcClient.XML_RESPONSE_WEB_TIME);
                return result;
            }
        }.execute();
    }

    public HashMap<?, ?> getTime() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<HashMap<?, ?>>(this){

            public HashMap<?, ?> execute() throws XmlRpcException {
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                if (response != null) {
                    String[] stringArray = XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE;
                    int n = XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String exclude = stringArray[n2];
                        response.remove(exclude);
                        ++n2;
                    }
                }
                return response;
            }
        }.execute();
    }

    public int login() throws XmlRpcException {
        this.userID = -1;
        final AuthenticationCredentials credentials = this.getLocation().getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            this.userID = new BugzillaXmlRpcOperation<Integer>((CommonXmlRpcClient)this){

                public Integer execute() throws XmlRpcException {
                    HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_USER_LOGIN, new Object[]{new HashMap<String, Object>(credentials){
                        {
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_LOGIN, authenticationCredentials.getUserName());
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_PASSWORD, authenticationCredentials.getPassword());
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_REMEMBER, true);
                        }
                    }});
                    if (response != null) {
                        Integer result = BugzillaXmlRpcClient.this.response2Integer(response, BugzillaXmlRpcClient.XML_RESPONSE_ID);
                        return result;
                    }
                    return null;
                }
            }.execute();
        }
        return this.userID;
    }

    private Object[] getUserInfoInternal(final Object[] callParm) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_USER_GET, callParm);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_USERS);
                return result;
            }
        }.execute();
    }

    public Object[] getUserInfoFromIDs(Integer[] ids) throws XmlRpcException {
        return this.getUserInfoInternal(new Object[]{new HashMap<String, Object[]>(ids){
            {
                this.put("ids", integerArray);
            }
        }});
    }

    public Object[] getUserInfoFromNames(String[] names) throws XmlRpcException {
        return this.getUserInfoInternal(new Object[]{new HashMap<String, Object[]>(names){
            {
                this.put(BugzillaXmlRpcClient.XML_PARAMETER_NAMES, stringArray);
            }
        }});
    }

    public Object[] getUserInfoWithMatch(String[] matchs) throws XmlRpcException {
        HashMap<String, String[]> parmArray = new HashMap<String, String[]>();
        Object[] callParm = new Object[]{parmArray};
        parmArray.put(XML_PARAMETER_MATCH, matchs);
        return this.getUserInfoInternal(callParm);
    }

    private Object[] getFieldsInternal(final Object[] callParm) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_BUG_FIELDS, callParm);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_FIELDS);
                return result;
            }
        }.execute();
    }

    public Object[] getAllFields() throws XmlRpcException {
        return this.getFieldsInternal(null);
    }

    public Object[] getFieldsWithNames(String[] names) throws XmlRpcException {
        return this.getFieldsInternal(new Object[]{new HashMap<String, Object[]>(names){
            {
                this.put(BugzillaXmlRpcClient.XML_PARAMETER_NAMES, stringArray);
            }
        }});
    }

    public Object[] getFieldsWithIDs(Integer[] ids) throws XmlRpcException {
        return this.getFieldsInternal(new Object[]{new HashMap<String, Object[]>(ids){
            {
                this.put("ids", integerArray);
            }
        }});
    }

    public Object[] getSelectableProducts() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_PRODUCT_GET_SELECTABLE, null);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getEnterableProducts() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_PRODUCT_GET_ENTERABLE, null);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getAccessibleProducts() throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_PRODUCT_GET_ACCESSIBLE, null);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getProducts(final Integer[] ids) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>((CommonXmlRpcClient)this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call((IProgressMonitor)new NullProgressMonitor(), BugzillaXmlRpcClient.XML_PRODUCT_GET, new Object[]{new HashMap<String, Object[]>(ids){
                    {
                        this.put("ids", integerArray);
                    }
                }});
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_PRODUCTS);
                return result;
            }
        }.execute();
    }

    private Object[] response2ObjectArray(HashMap<?, ?> response, String name) throws XmlRpcException {
        Object[] result;
        if (response == null) {
            return null;
        }
        try {
            result = (Object[])response.get(name);
        }
        catch (ClassCastException e) {
            Object[] result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private Integer response2Integer(HashMap<?, ?> response, String name) throws XmlRpcException {
        Integer result;
        if (response == null) {
            return null;
        }
        try {
            result = (Integer)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private String response2String(HashMap<?, ?> response, String name) throws XmlRpcException {
        String result;
        if (response == null) {
            return null;
        }
        try {
            result = (String)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private Date response2Date(HashMap<?, ?> response, String name) throws XmlRpcException {
        Date result;
        if (response == null) {
            return null;
        }
        try {
            result = (Date)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }
}

