/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.mylyn.internal.java.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingEditorTracker
extends AbstractEditorTracker {
    protected Map<JavaEditor, ActiveFoldingListener> editorListenerMap = new HashMap<JavaEditor, ActiveFoldingListener>();

    public void editorOpened(IEditorPart part) {
        if (part instanceof JavaEditor) {
            this.registerEditor((JavaEditor)part);
        }
    }

    public void editorClosed(IEditorPart part) {
        if (part instanceof JavaEditor) {
            this.unregisterEditor((JavaEditor)part);
        }
    }

    public void registerEditor(JavaEditor editor) {
        if (this.editorListenerMap.containsKey(editor)) {
            return;
        }
        ActiveFoldingListener listener = new ActiveFoldingListener(editor);
        this.editorListenerMap.put(editor, listener);
    }

    public void unregisterEditor(JavaEditor editor) {
        ActiveFoldingListener listener = this.editorListenerMap.get(editor);
        if (listener != null) {
            listener.dispose();
        }
        this.editorListenerMap.remove(editor);
    }

    public Map<JavaEditor, ActiveFoldingListener> getEditorListenerMap() {
        return this.editorListenerMap;
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }
}

