/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.editor;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.editor.FocusedJavaProposalProcessor;

public class FocusedJavaAllProposalComputer
extends JavaCompletionProposalComputer {
    public static final int CONSTRUCTOR_INVOCATION = 26;
    public static final int ANONYMOUS_CLASS_CONSTRUCTOR_INVOCATION = 27;
    private static Field field;
    private boolean coreContextExceptionLogged;

    static {
        try {
            field = JavaContentAssistInvocationContext.class.getDeclaredField("fCoreContext");
            field.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    public FocusedJavaAllProposalComputer() {
        FocusedJavaProposalProcessor.getDefault().addMonitoredComputer((IJavaCompletionProposalComputer)this);
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (this.shouldReturnResults()) {
            block5: {
                if (field != null) {
                    try {
                        CompletionContext coreContext = (CompletionContext)field.get(context);
                        if (coreContext != null && !coreContext.isExtended()) {
                            field.set(context, null);
                        }
                    }
                    catch (Exception e) {
                        if (this.coreContextExceptionLogged) break block5;
                        this.coreContextExceptionLogged = true;
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.java.ui", "An error was encountered while computing Task-Focused content assist. To recover use Restore Defaults in Preferences > Java > Editor > Content Assist > Advanced.", (Throwable)e));
                    }
                }
            }
            List proposals = super.computeCompletionProposals(context, monitor);
            return FocusedJavaProposalProcessor.getDefault().projectInterestModel((IJavaCompletionProposalComputer)this, proposals);
        }
        return Collections.emptyList();
    }

    private boolean shouldReturnResults() {
        if (JavaUiUtil.isDefaultAssistActive("org.eclipse.jdt.ui.javaAllProposalCategory")) {
            return false;
        }
        Set<String> disabledIds = JavaUiUtil.getDisabledIds(JavaPlugin.getDefault().getPreferenceStore());
        return disabledIds.contains("org.eclipse.jdt.ui.javaNoTypeProposalCategory") || disabledIds.contains("org.eclipse.jdt.ui.javaTypeProposalCategory");
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        CompletionProposalCollector collector = super.createCollector(context);
        collector.setIgnored(13, false);
        collector.setIgnored(1, false);
        try {
            collector.setIgnored(27, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        collector.setIgnored(2, false);
        collector.setIgnored(25, false);
        collector.setIgnored(3, false);
        collector.setIgnored(4, false);
        collector.setIgnored(5, false);
        collector.setIgnored(7, false);
        collector.setIgnored(12, false);
        collector.setIgnored(6, false);
        try {
            collector.setIgnored(26, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        collector.setIgnored(24, false);
        collector.setIgnored(8, false);
        collector.setIgnored(11, false);
        collector.setIgnored(10, false);
        collector.setIgnored(9, false);
        return collector;
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        int invocationOffset = context.getInvocationOffset();
        int typeContext = super.guessContextInformationPosition(context);
        int methodContext = this.guessMethodContextInformationPosition2(context);
        if (typeContext != invocationOffset && typeContext > methodContext) {
            return typeContext;
        }
        if (methodContext != invocationOffset) {
            return methodContext;
        }
        return invocationOffset;
    }

    protected final int guessMethodContextInformationPosition2(ContentAssistInvocationContext context) {
        int paren;
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) != -1) {
            int token = scanner.previousToken(paren - 1, bound);
            if (token == 2000 || token == 14) {
                return paren + 1;
            }
            pos = paren - 1;
        }
        return contextPosition;
    }
}

