/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.mylyn.internal.oslc.core.OslcCreationDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcSelectionDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceFactory;
import org.eclipse.mylyn.internal.oslc.core.ServiceContributor;
import org.eclipse.mylyn.internal.oslc.core.ServiceHome;
import org.eclipse.mylyn.internal.oslc.core.cm.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcServiceDescriptor
implements Serializable {
    private static final long serialVersionUID = -3981264972265788764L;
    private final Set<OslcCreationDialogDescriptor> creationDialogs;
    private final Set<OslcServiceFactory> serviceFactories;
    private final Set<OslcSelectionDialogDescriptor> selectionDialogs;
    private ServiceContributor contributor;
    private ServiceHome home;
    private String aboutUrl;
    private String simpleQueryUrl;
    private OslcServiceFactory defaultFactory;
    private OslcCreationDialogDescriptor defaultDialog;
    private String title;
    private String description;

    public OslcServiceDescriptor(String aboutUrl) {
        this.aboutUrl = aboutUrl;
        this.creationDialogs = new CopyOnWriteArraySet<OslcCreationDialogDescriptor>();
        this.serviceFactories = new CopyOnWriteArraySet<OslcServiceFactory>();
        this.selectionDialogs = new CopyOnWriteArraySet<OslcSelectionDialogDescriptor>();
    }

    public void clear() {
        this.creationDialogs.clear();
        this.serviceFactories.clear();
        this.selectionDialogs.clear();
        this.contributor = null;
        this.title = null;
        this.description = null;
        this.defaultFactory = null;
        this.simpleQueryUrl = null;
    }

    public Set<OslcCreationDialogDescriptor> getCreationDialogs() {
        return Collections.unmodifiableSet(this.creationDialogs);
    }

    public void addCreationDialog(OslcCreationDialogDescriptor descriptor) {
        this.creationDialogs.add(descriptor);
        if (descriptor.isDefault()) {
            this.defaultDialog = descriptor;
        }
    }

    public String getAboutUrl() {
        return this.aboutUrl;
    }

    public void setAboutUrl(String url) {
        this.aboutUrl = url;
    }

    public void setDefaultCreationDialog(OslcCreationDialogDescriptor defaultDialog) {
        this.defaultDialog = defaultDialog;
    }

    public OslcCreationDialogDescriptor getDefaultCreationDialog() {
        return this.defaultDialog;
    }

    public void setDefaultFactory(OslcServiceFactory factory) {
        this.defaultFactory = factory;
    }

    public OslcServiceFactory getDefaultFactory() {
        if (this.defaultFactory == null && !this.serviceFactories.isEmpty()) {
            return this.serviceFactories.iterator().next();
        }
        return this.defaultFactory;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return Messages.OslcServiceDescriptor_Service_Available;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return Messages.OslcServiceDescriptor_Service_Available;
    }

    public String getSimpleQueryUrl() {
        return this.simpleQueryUrl;
    }

    public void setSimpleQueryUrl(String simpleQueryUrl) {
        this.simpleQueryUrl = simpleQueryUrl;
    }

    public Set<OslcSelectionDialogDescriptor> getSelectionDialogs() {
        return Collections.unmodifiableSet(this.selectionDialogs);
    }

    public void addSelectionDialog(OslcSelectionDialogDescriptor dialog) {
        this.selectionDialogs.add(dialog);
    }

    public OslcSelectionDialogDescriptor getDefaultSelectionDialog() {
        for (OslcSelectionDialogDescriptor dialog : this.selectionDialogs) {
            if (!dialog.isDefault()) continue;
            return dialog;
        }
        return null;
    }

    public Set<OslcServiceFactory> getFactories() {
        return Collections.unmodifiableSet(this.serviceFactories);
    }

    public void addServiceFactory(OslcServiceFactory factory) {
        this.serviceFactories.add(factory);
    }

    public void setContributor(ServiceContributor contributor) {
        this.contributor = contributor;
    }

    public ServiceContributor getContributor() {
        return this.contributor;
    }

    public void setHome(ServiceHome home) {
        this.home = home;
    }

    public ServiceHome getHome() {
        return this.home;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.aboutUrl == null ? 0 : this.aboutUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OslcServiceDescriptor)) {
            return false;
        }
        OslcServiceDescriptor other = (OslcServiceDescriptor)obj;
        return !(this.aboutUrl == null ? other.aboutUrl != null : !this.aboutUrl.equals(other.aboutUrl));
    }

    public String toString() {
        return this.title;
    }
}

