/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskListViewHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class GoToUnreadTaskHandler
extends AbstractTaskListViewHandler {
    public static final String ID_NEXT = "org.eclipse.mylyn.tasklist.actions.goToNextUnread";
    public static final String ID_PREVIOUS = "org.eclipse.mylyn.tasklist.actions.goToPreviousUnread";
    private TreeWalker.Direction direction = TreeWalker.Direction.DOWN;

    public TreeWalker.Direction getDirection() {
        return this.direction;
    }

    private TreePath getUnreadItem(TreeViewer treeViewer, Tree tree) {
        TreeItem[] selection = tree.getSelection();
        TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
        TreeWalker.TreeVisitor visitor = new TreeWalker.TreeVisitor(){

            public boolean visit(Object object) {
                ITask task;
                return object instanceof ITask && (task = (ITask)object).getSynchronizationState().isIncoming();
            }
        };
        TreeWalker treeWalker = new TreeWalker(treeViewer);
        treeWalker.setDirection(this.direction);
        treeWalker.setExpandNodes(true);
        return treeWalker.walk(visitor, selectedItem);
    }

    protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) {
        TreeViewer treeViewer = taskListView.getViewer();
        Tree tree = treeViewer.getTree();
        TreePath treePath = null;
        try {
            tree.setRedraw(false);
            treePath = this.getUnreadItem(treeViewer, tree);
        }
        finally {
            tree.setRedraw(true);
        }
        if (treePath != null) {
            treeViewer.expandToLevel((Object)treePath, 0);
            treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
        }
    }

    public void setDirection(TreeWalker.Direction direction) {
        this.direction = direction;
    }

    public static void execute(ExecutionEvent event, TreeWalker.Direction direction) throws ExecutionException {
        GoToUnreadTaskHandler handler = new GoToUnreadTaskHandler(){};
        handler.setDirection(direction);
        handler.execute(event);
    }

    public static class GoToNextUnreadTaskHandler
    extends GoToUnreadTaskHandler {
        public GoToNextUnreadTaskHandler() {
            this.setDirection(TreeWalker.Direction.DOWN);
        }
    }

    public static class GoToPreviousUnreadTaskHandler
    extends GoToUnreadTaskHandler {
        public GoToPreviousUnreadTaskHandler() {
            this.setDirection(TreeWalker.Direction.UP);
        }
    }
}

