/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.ui.Messages;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;
import org.eclipse.mylyn.internal.trac.ui.TracImages;
import org.eclipse.mylyn.internal.trac.ui.TracSearchHandler;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracQueryPage;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.NewWebTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracConnectorUi
extends AbstractRepositoryConnectorUi {
    public TracConnectorUi() {
        TasksUiPlugin.getDefault().addSearchHandler((AbstractSearchHandler)new TracSearchHandler());
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        return TracHyperlinkUtil.findTicketHyperlinks(repository, text, lineOffset, regionOffset);
    }

    public String getTaskKindLabel(ITask repositoryTask) {
        return Messages.TracConnectorUi_Ticket;
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new TracRepositorySettingsPage(taskRepository);
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new TracQueryPage(repository);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public IWizard getNewTaskWizard(TaskRepository repository, ITaskMapping selection) {
        if (TracRepositoryConnector.hasRichEditor((TaskRepository)repository)) {
            return new NewTaskWizard(repository, selection);
        }
        return new NewWebTaskWizard(repository, String.valueOf(repository.getRepositoryUrl()) + "/newticket", selection);
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        wizard.addPage((IWizardPage)new TracQueryPage(repository, query));
        return wizard;
    }

    public String getConnectorKind() {
        return "trac";
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        TracRepositoryConnector.TaskKind taskKind = TracRepositoryConnector.TaskKind.fromString((String)task.getTaskKind());
        if (taskKind == TracRepositoryConnector.TaskKind.DEFECT) {
            return TracImages.OVERLAY_DEFECT;
        }
        if (taskKind == TracRepositoryConnector.TaskKind.ENHANCEMENT) {
            return TracImages.OVERLAY_ENHANCEMENT;
        }
        if (taskKind == TracRepositoryConnector.TaskKind.STORY) {
            return TracImages.OVERLAY_STORY;
        }
        if (taskKind == TracRepositoryConnector.TaskKind.TASK) {
            return null;
        }
        return super.getTaskKindOverlay(task);
    }

    public List<LegendElement> getLegendElements() {
        ArrayList<LegendElement> legendItems = new ArrayList<LegendElement>();
        legendItems.add(LegendElement.createTask((String)TracRepositoryConnector.TaskKind.DEFECT.toString(), (ImageDescriptor)TracImages.OVERLAY_DEFECT));
        legendItems.add(LegendElement.createTask((String)TracRepositoryConnector.TaskKind.ENHANCEMENT.toString(), (ImageDescriptor)TracImages.OVERLAY_ENHANCEMENT));
        legendItems.add(LegendElement.createTask((String)TracRepositoryConnector.TaskKind.TASK.toString(), null));
        return legendItems;
    }

    public String getReplyText(TaskRepository taskRepository, ITask task, ITaskComment taskComment, boolean includeTask) {
        if (taskComment == null) {
            return NLS.bind((String)Messages.TracConnectorUi_Replying_to__ticket_X_X_, (Object)task.getTaskKey(), (Object)task.getOwner());
        }
        if (includeTask) {
            return NLS.bind((String)Messages.TracConnectorUi_Replying_to__comment_ticket_X_X_X_, (Object[])new Object[]{task.getTaskKey(), taskComment.getNumber(), taskComment.getAuthor().getPersonId()});
        }
        return NLS.bind((String)Messages.TracConnectorUi_Replying_to__comment_X_X_, (Object)taskComment.getNumber(), (Object)taskComment.getAuthor().getPersonId());
    }

    public IWizardPage getTaskAttachmentPage(TaskAttachmentModel model) {
        TaskAttachmentPage page = new TaskAttachmentPage(model);
        page.setNeedsReplaceExisting(true);
        return page;
    }
}

