/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.validation;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.validation.StandaloneMarkupValidator;
import org.eclipse.mylyn.internal.wikitext.core.validation.TestMarkupValidationRule;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

public class StandaloneMarkupValidatorTest
extends TestCase {
    private StandaloneMarkupValidator validator;

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new StandaloneMarkupValidator();
        this.validator.setClassLoader(StandaloneMarkupValidatorTest.class.getClassLoader());
        this.validator.computeRules("TestMarkupLanguage", StandaloneMarkupValidatorTest.class.getResource("test-plugin.xml"));
    }

    public void testSimple() {
        List problems = this.validator.validate("some text ERROR more text WARNING and ERROR");
        StandaloneMarkupValidatorTest.assertNotNull((Object)problems);
        StandaloneMarkupValidatorTest.assertEquals((int)3, (int)problems.size());
        ValidationProblem first = (ValidationProblem)problems.get(0);
        StandaloneMarkupValidatorTest.assertEquals((Object)ValidationProblem.Severity.ERROR, (Object)first.getSeverity());
        StandaloneMarkupValidatorTest.assertEquals((int)10, (int)first.getOffset());
        StandaloneMarkupValidatorTest.assertEquals((int)5, (int)first.getLength());
        ValidationProblem second = (ValidationProblem)problems.get(1);
        StandaloneMarkupValidatorTest.assertEquals((Object)ValidationProblem.Severity.WARNING, (Object)second.getSeverity());
        StandaloneMarkupValidatorTest.assertEquals((int)26, (int)second.getOffset());
        StandaloneMarkupValidatorTest.assertEquals((int)7, (int)second.getLength());
        ValidationProblem third = (ValidationProblem)problems.get(2);
        StandaloneMarkupValidatorTest.assertEquals((Object)ValidationProblem.Severity.ERROR, (Object)third.getSeverity());
        StandaloneMarkupValidatorTest.assertEquals((int)38, (int)third.getOffset());
        StandaloneMarkupValidatorTest.assertEquals((int)5, (int)third.getLength());
    }

    public void testImmutability() {
        StandaloneMarkupValidator validator = StandaloneMarkupValidator.getValidator((String)"Test");
        try {
            validator.getRules().clear();
            StandaloneMarkupValidatorTest.fail((String)"not immutable");
        }
        catch (Exception exception) {}
        try {
            validator.getRules().add(new TestMarkupValidationRule());
            StandaloneMarkupValidatorTest.fail((String)"not immutable");
        }
        catch (Exception exception) {}
        try {
            validator.setClassLoader(StandaloneMarkupValidator.class.getClassLoader());
            StandaloneMarkupValidatorTest.fail((String)"not immutable");
        }
        catch (Exception exception) {}
    }

    public void testMutability() {
        this.validator.getRules().clear();
        this.validator.getRules().add(new TestMarkupValidationRule());
        this.validator.setClassLoader(StandaloneMarkupValidator.class.getClassLoader());
    }
}

