/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class HtmlDocumentBuilderTest
extends TestCase {
    private MarkupParser parser;
    private StringWriter out;
    private HtmlDocumentBuilder builder;

    public void setUp() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        this.builder = new HtmlDocumentBuilder((Writer)this.out);
        this.parser.setBuilder((DocumentBuilder)this.builder);
    }

    public void testRelativeUrlWithBase() throws URISyntaxException {
        this.builder.setBase(new URI("http://www.foo.bar/baz"));
        this.parser.parse("\"An URL\":foo/bar.html");
        String html = this.out.toString();
        TestUtil.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar/baz/foo/bar.html\">An URL</a>"));
    }

    public void testAbsoluteUrlWithBase() throws URISyntaxException {
        this.builder.setBase(new URI("http://www.foo.bar/baz"));
        this.parser.parse("\"An URL\":http://www.baz.ca/foo/bar.html");
        String html = this.out.toString();
        TestUtil.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.baz.ca/foo/bar.html\">An URL</a>"));
    }

    public void testRelativeUrlWithFileBase() throws URISyntaxException {
        this.builder.setBase(new File("/base/2/with space/").toURI());
        this.parser.parse("\"An URL\":foo/bar.html");
        String html = this.out.toString();
        TestUtil.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"file:/base/2/with%20space/foo/bar.html\">An URL</a>"));
    }
}

