/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToDocbook;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class TextileToDocbookTest
extends TestCase {
    private MarkupToDocbook textileToDocbook;

    public void setUp() {
        this.textileToDocbook = new MarkupToDocbook();
        this.textileToDocbook.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
    }

    public void testHeader() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. title1\n\nContent para 1\n\nh1. title2\n\nMore content\n");
        TestUtil.println("Book: " + book);
    }

    public void testMultipleNestedElements() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. title1\n\nContent para 1\n* a\n* list of\n* items\n");
        TestUtil.println("Book: " + book);
    }

    public void testNestedHeaders() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. title1\n\nContent para 1\nh2. title2\n\nContent para2\n\nh1. title3\n\npara3");
        TestUtil.println("Book: " + book);
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("</chapter>\\s*<chapter", 8).matcher(book).find());
    }

    public void testHeaderWithAcronym() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. TBA(To Be Announced) plus more content in the header\n\nContent para 1");
        TestUtil.println("Book: " + book);
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<glossterm>TBA</glossterm>\\s*plus more", 8).matcher(book).find());
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<glossterm>TBA</glossterm>\\s*<glossdef>", 8).matcher(book).find());
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<glossdef>\\s*<para>To Be Announced", 8).matcher(book).find());
    }

    public void testBlockCode() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. A\n\nsome content\n\nbc. public class Foo {\n}\n");
        TestUtil.println("Book: " + book);
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<literallayout>\\s*<code>", 8).matcher(book).find());
    }

    public void testBlockCodeExtended() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("h1. A\n\nsome content\n\nbc.. \npublic class Foo {\n}\n\n\nsome other content");
        TestUtil.println("Book: " + book);
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<literallayout>\\s*<code>", 8).matcher(book).find());
    }

    public void testFootnotes() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("something[1] with a footnote\n\nfn1. the footnote text");
        TestUtil.println("Book: " + book);
        Matcher matcher = Pattern.compile("<link\\s*linkend=\"(___fn.*?)\">", 8).matcher(book);
        TextileToDocbookTest.assertTrue((boolean)matcher.find());
        String linkend = matcher.group(1);
        TextileToDocbookTest.assertNotNull((Object)linkend);
        TextileToDocbookTest.assertTrue((boolean)Pattern.compile("<para\\s*id=\"" + Pattern.quote(linkend) + "\">", 8).matcher(book).find());
    }

    public void testImageScaling() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("Here comes an !{width:80%}imageUrl! with more text");
        TestUtil.println("Book: " + book);
        Matcher matcher = Pattern.compile("<imagedata .* scale=\"80\"/>", 8).matcher(book);
        TextileToDocbookTest.assertTrue((boolean)matcher.find());
    }

    public void testImageWidth() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("Here comes an !{width:80px}imageUrl! with more text");
        TestUtil.println("Book: " + book);
        Matcher matcher = Pattern.compile("<imagedata .* width=\"80px\"/>", 8).matcher(book);
        TextileToDocbookTest.assertTrue((boolean)matcher.find());
    }

    public void testImageWidthDepth() throws Exception {
        this.textileToDocbook.setBookTitle("Test");
        String book = this.textileToDocbook.parse("Here comes an !{width:80px;height:90px;}imageUrl! with more text");
        TestUtil.println("Book: " + book);
        Matcher matcher = Pattern.compile("<imagedata .* width=\"80px\"\\s.*?depth=\"90px\"/>", 8).matcher(book);
        TextileToDocbookTest.assertTrue((boolean)matcher.find());
    }
}

