/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTableLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

abstract class AbstractGridRowLayout
extends CompositeTableLayout {
    protected static final int CELL_BORDER_WIDTH = 2;
    private int[] weights = new int[0];
    private int sumOfAllWeights;
    private boolean fittingHorizontally = false;

    public AbstractGridRowLayout() {
    }

    public AbstractGridRowLayout(int[] weights) {
        this.setWeights(weights);
    }

    public AbstractGridRowLayout(int[] weights, boolean fittingHorizontally) {
        this.setWeights(weights);
        this.setFittingHorizontally(fittingHorizontally);
    }

    protected Point computeSize(Composite child, int wHint, int hHint, boolean flushCache) {
        int preferredWidth = this.computePreferredWidth(child);
        int preferredHeight = this.computeMaxHeight(child);
        return new Point(preferredWidth, preferredHeight);
    }

    protected void layout(Composite child, boolean flushCache) {
        if (this.isFittingHorizontally() || this.isWidthWiderThanAllColumns(child)) {
            this.layoutWeightedHeaderOrRow(child);
        } else {
            this.layoutAbsoluteWidthHeaderOrRow(child);
        }
    }

    protected boolean isWidthWiderThanAllColumns(Composite headerOrRow) {
        if (this.isFittingHorizontally()) {
            return false;
        }
        int allColumnsTotalWidth = this.computePreferredWidth(headerOrRow);
        return this.getAvailableWidth(headerOrRow) > allColumnsTotalWidth;
    }

    protected int getAvailableWidth(Composite headerOrRow) {
        return headerOrRow.getParent().getParent().getSize().x;
    }

    private int computePreferredWidth(Composite child) {
        if (this.isFittingHorizontally()) {
            return 1;
        }
        int allColumnsTotalWidth = 0;
        int[] colWeights = this.getWeights();
        int i = 0;
        while (i < colWeights.length) {
            allColumnsTotalWidth += colWeights[i] + 4;
            ++i;
        }
        return allColumnsTotalWidth;
    }

    private int layoutWeightedHeaderOrRow(Composite child) {
        int left;
        int widthRemaining;
        int numChildren = this.getNumColumns(child);
        if (numChildren == 0) {
            return 50;
        }
        int maxHeight = this.computeMaxHeight(child);
        int[] colWeights = this.getWeights();
        colWeights = this.isFittingHorizontally() ? this.checkWeights(colWeights, numChildren) : this.computeWeights(colWeights, numChildren);
        int totalSize = widthRemaining = child.getParent().getSize().x;
        int i = 0;
        while (i < numChildren - 1) {
            left = totalSize - widthRemaining;
            Widget columnObject = this.getColumnAt(child, i);
            int leftPos = left + 2;
            int width = (int)((float)colWeights[i] / 100.0f * (float)totalSize);
            int widthIncludingBorderWidth = width - 4;
            int desiredHeight = this.computeColumnSize((Widget)columnObject, (int)-1, (int)-1, (boolean)false).y;
            int top = this.computeTop(maxHeight, desiredHeight);
            this.setBounds(columnObject, leftPos, top, widthIncludingBorderWidth, desiredHeight - 1);
            widthRemaining -= width;
            ++i;
        }
        Widget lastColumn = this.getColumnAt(child, numChildren - 1);
        left = totalSize - widthRemaining;
        int desiredHeight = this.computeColumnSize((Widget)lastColumn, (int)-1, (int)-1, (boolean)false).y;
        int top = this.computeTop(maxHeight, desiredHeight);
        this.setBounds(lastColumn, left + 2, top, widthRemaining - 4, desiredHeight);
        return maxHeight;
    }

    private int layoutAbsoluteWidthHeaderOrRow(Composite child) {
        int numChildren = this.getNumColumns(child);
        if (numChildren == 0) {
            return 50;
        }
        int maxHeight = this.computeMaxHeight(child);
        int[] colWidths = this.getWeights();
        int left = 0;
        int i = 0;
        while (i < numChildren) {
            Widget column = this.getColumnAt(child, i);
            int desiredHeight = this.computeColumnSize((Widget)column, (int)-1, (int)-1, (boolean)false).y;
            int top = this.computeTop(maxHeight, desiredHeight);
            this.setBounds(column, left + 2, top, colWidths[i], desiredHeight);
            left += colWidths[i] + 4;
            ++i;
        }
        return maxHeight;
    }

    protected abstract int getNumColumns(Composite var1);

    protected abstract int computeMaxHeight(Composite var1);

    protected abstract Widget getColumnAt(Composite var1, int var2);

    protected abstract Point computeColumnSize(Widget var1, int var2, int var3, boolean var4);

    protected abstract void setBounds(Widget var1, int var2, int var3, int var4, int var5);

    private int computeTop(int maxHeight, int desiredHeight) {
        return (maxHeight - desiredHeight) / 2;
    }

    private int[] computeWeights(int[] weights, int numChildren) {
        if (weights.length != numChildren) {
            return this.checkWeights(weights, numChildren);
        }
        int[] realWeights = new int[numChildren];
        int total = 100;
        int i = 0;
        while (i < realWeights.length) {
            realWeights[i] = (int)((double)weights[i] / (double)this.getSumOfAllWeights() * 100.0);
            total -= realWeights[i];
            ++i;
        }
        i = 0;
        while (total > 0) {
            int n = i++;
            realWeights[n] = realWeights[n] + 1;
            --total;
            if (i < realWeights.length) continue;
            i = 0;
        }
        return realWeights;
    }

    private int[] checkWeights(int[] weights, int numChildren) {
        if (weights.length == numChildren) {
            int sum = 0;
            int i = 0;
            while (i < weights.length) {
                sum += weights[i];
                ++i;
            }
            if (sum == 100) {
                return weights;
            }
        }
        int[] result = new int[numChildren];
        int weight = 100 / numChildren;
        int extra = 100 % numChildren;
        int i = 0;
        while (i < result.length - 1) {
            result[i] = weight;
            if (extra > 0) {
                int n = i;
                result[n] = result[n] + 1;
                --extra;
            }
            ++i;
        }
        result[numChildren - 1] = weight + extra;
        return result;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public AbstractGridRowLayout setWeights(int[] weights) {
        this.weights = weights;
        this.sumOfAllWeights = 0;
        int i = 0;
        while (i < weights.length) {
            this.sumOfAllWeights += weights[i];
            ++i;
        }
        return this;
    }

    public int getSumOfAllWeights() {
        return this.sumOfAllWeights;
    }

    public boolean isFittingHorizontally() {
        return this.fittingHorizontally;
    }

    public AbstractGridRowLayout setFittingHorizontally(boolean fittingHorizontally) {
        this.fittingHorizontally = fittingHorizontally;
        return this;
    }
}

