/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractSortableHeader
extends Composite {
    protected List labels;
    private String[] labelStrings;
    private MouseAdapter sortMouseAdapter;
    private Boolean sortDescending = null;
    private int lastSortColumn = -1;
    protected Image sortUpIndicator = new Image((Device)Display.getDefault(), this.getUpImageData());
    protected Image sortDownIndicator = new Image((Device)Display.getDefault(), this.getDownImageData());
    private Image sortIndicator = null;
    final int width = 8;
    final int height = 4;

    private ImageData getEmptyImageData() {
        int whitePixel;
        RGB whiteRGB = new RGB(255, 255, 255);
        RGB blackRGB = new RGB(0, 0, 0);
        PaletteData palette = new PaletteData(new RGB[]{whiteRGB, blackRGB});
        ImageData imageData = new ImageData(8, 4, 1, palette);
        imageData.transparentPixel = whitePixel = imageData.palette.getPixel(whiteRGB);
        return imageData;
    }

    private ImageData getUpImageData() {
        ImageData imageData = this.getEmptyImageData();
        int numTransparentPixels = 0;
        int row = 3;
        while (row >= 0) {
            int col = numTransparentPixels;
            while (col < 4) {
                imageData.setPixel(col, row, 1);
                imageData.setPixel(8 - col - 1, row, 1);
                ++col;
            }
            ++numTransparentPixels;
            --row;
        }
        return imageData;
    }

    private ImageData getDownImageData() {
        ImageData imageData = this.getEmptyImageData();
        int numTransparentPixels = 0;
        int row = 0;
        while (row < 4) {
            int col = numTransparentPixels;
            while (col < 4) {
                imageData.setPixel(col, row, 1);
                imageData.setPixel(8 - col - 1, row, 1);
                ++col;
            }
            ++numTransparentPixels;
            ++row;
        }
        return imageData;
    }

    public AbstractSortableHeader(Composite parent, int style) {
        super(parent, style);
        this.makeMouseAdapter();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AbstractSortableHeader.this.sortUpIndicator.dispose();
                AbstractSortableHeader.this.sortDownIndicator.dispose();
            }
        });
    }

    private boolean toggleSortDirection() {
        if (this.sortDescending == null) {
            this.sortDescending = Boolean.TRUE;
            this.sortIndicator = this.sortDownIndicator;
            return this.sortDescending;
        }
        this.sortDescending = new Boolean(this.sortDescending == false);
        this.sortIndicator = this.sortDescending != false ? this.sortDownIndicator : this.sortUpIndicator;
        return this.sortDescending;
    }

    private void makeMouseAdapter() {
        this.sortMouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CLabel label = (CLabel)e.widget;
                int c = AbstractSortableHeader.this.labels.indexOf(label);
                if (c != AbstractSortableHeader.this.lastSortColumn) {
                    AbstractSortableHeader.this.sortDescending = null;
                    AbstractSortableHeader.this.sortIndicator = null;
                }
                AbstractSortableHeader.this.lastSortColumn = c;
                AbstractSortableHeader.this.sortOnColumn(c, AbstractSortableHeader.this.toggleSortDirection());
                int i = 0;
                while (i < AbstractSortableHeader.this.labels.size()) {
                    CLabel labelToSet = (CLabel)AbstractSortableHeader.this.labels.get(i);
                    if (i != c) {
                        labelToSet.setImage(null);
                    } else {
                        labelToSet.setImage(AbstractSortableHeader.this.sortIndicator);
                    }
                    ++i;
                }
            }
        };
    }

    protected abstract void sortOnColumn(int var1, boolean var2);

    public void setColumnText(String[] columnText) {
        this.labelStrings = columnText;
        this.initialize();
    }

    private void initialize() {
        this.labels = new ArrayList();
        String[] fields = this.labelStrings;
        int i = 0;
        while (i < fields.length) {
            CLabel label = new CLabel((Composite)this, 0);
            if (label.isDisposed()) {
                return;
            }
            this.labels.add(label);
            label.setText(fields[i]);
            this.initializeLabel(label);
            ++i;
        }
    }

    protected void initializeLabel(CLabel label) {
        label.addMouseListener((MouseListener)this.sortMouseAdapter);
    }
}

