/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable.day.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.nebula.widgets.compositetable.day.ICalendarableItemControl;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class DayEditorCalendarableItemControl
extends Canvas
implements ICalendarableItemControl {
    private static final int MARGIN = 3;
    private Label label = null;
    private Color BORDER_COLOR;
    private Color SELECTED_BORDER_COLOR;
    private Color BACKGROUND_COLOR;
    private Color SELECTED_BACKGROUND_COLOR;
    private int clipping;
    private int continued;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Rectangle bounds = DayEditorCalendarableItemControl.this.getBounds();
            Color savedForeground = e.gc.getForeground();
            Color savedBackground = e.gc.getBackground();
            if ((DayEditorCalendarableItemControl.this.continued & 0x80) != 0 && (DayEditorCalendarableItemControl.this.clipping & 0x80) == 0) {
                e.gc.setForeground(Display.getCurrent().getSystemColor(2));
                e.gc.setBackground(Display.getCurrent().getSystemColor(2));
            } else {
                e.gc.setForeground(Display.getCurrent().getSystemColor(16));
                e.gc.setBackground(Display.getCurrent().getSystemColor(16));
            }
            if ((DayEditorCalendarableItemControl.this.clipping & 0x80) != 0 || (DayEditorCalendarableItemControl.this.continued & 0x80) != 0) {
                int arrow = 3;
                while (arrow < bounds.width - 6) {
                    int[] nArray = new int[6];
                    nArray[0] = arrow;
                    nArray[1] = 2;
                    nArray[2] = arrow + 3;
                    nArray[4] = arrow + 6;
                    nArray[5] = 2;
                    int[] arrowPoints = nArray;
                    e.gc.fillPolygon(arrowPoints);
                    e.gc.drawPolygon(arrowPoints);
                    arrow += 9;
                }
            }
            if ((DayEditorCalendarableItemControl.this.continued & 0x400) != 0 && (DayEditorCalendarableItemControl.this.clipping & 0x400) == 0) {
                e.gc.setForeground(Display.getCurrent().getSystemColor(2));
                e.gc.setBackground(Display.getCurrent().getSystemColor(2));
            } else {
                e.gc.setForeground(Display.getCurrent().getSystemColor(16));
                e.gc.setBackground(Display.getCurrent().getSystemColor(16));
            }
            if ((DayEditorCalendarableItemControl.this.clipping & 0x400) != 0 || (DayEditorCalendarableItemControl.this.continued & 0x400) != 0) {
                int bottom = bounds.height - 1;
                int marginBottom = bounds.height - 3;
                int arrow = 3;
                while (arrow < bounds.width - 6) {
                    int[] arrowPoints = new int[]{arrow, marginBottom, arrow + 3, bottom, arrow + 6, marginBottom};
                    e.gc.fillPolygon(arrowPoints);
                    e.gc.drawPolygon(arrowPoints);
                    arrow += 9;
                }
            }
            e.gc.setForeground(savedForeground);
            e.gc.setBackground(savedBackground);
        }
    };
    private List mouseListeners = new LinkedList();
    private MouseListener labelMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            e.widget = DayEditorCalendarableItemControl.this;
            for (MouseListener l : DayEditorCalendarableItemControl.this.mouseListeners) {
                l.mouseDoubleClick(e);
            }
        }

        public void mouseDown(MouseEvent e) {
            e.widget = DayEditorCalendarableItemControl.this;
            for (MouseListener l : DayEditorCalendarableItemControl.this.mouseListeners) {
                l.mouseDown(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            e.widget = DayEditorCalendarableItemControl.this;
            for (MouseListener l : DayEditorCalendarableItemControl.this.mouseListeners) {
                l.mouseUp(e);
            }
        }
    };
    private CalendarableItem calendarable;

    public DayEditorCalendarableItemControl(Composite parent, int style) {
        super(parent, style);
        Display display = parent.getDisplay();
        this.BACKGROUND_COLOR = new Color((Device)display, this.lighten(this.saturate(display.getSystemColor(32).getRGB(), 0.08f), 0.3f));
        this.BORDER_COLOR = new Color((Device)display, this.lighten(this.saturate(display.getSystemColor(31).getRGB(), 0.18f), 0.1f));
        this.SELECTED_BACKGROUND_COLOR = display.getSystemColor(1);
        this.SELECTED_BORDER_COLOR = new Color((Device)display, this.saturate(this.BORDER_COLOR.getRGB(), 0.4f));
        this.initialize();
    }

    private RGB saturate(RGB color, float saturation) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], saturation, hsb[2]);
    }

    private RGB lighten(RGB color, float amount) {
        float[] hsb = color.getHSB();
        float b = hsb[2] + hsb[2] * amount;
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new RGB(hsb[0], hsb[1], b);
    }

    public void dispose() {
        super.dispose();
        this.BORDER_COLOR.dispose();
        this.BACKGROUND_COLOR.dispose();
        this.SELECTED_BORDER_COLOR.dispose();
    }

    private void initialize() {
        this.setBackground(this.BACKGROUND_COLOR);
        this.label = new Label((Composite)this, 64);
        this.label.setText("Label");
        this.label.setBackground(this.BACKGROUND_COLOR);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 3;
        fillLayout.marginWidth = 3;
        this.setBackground(this.BORDER_COLOR);
        this.setLayout((Layout)fillLayout);
        this.addPaintListener(this.paintListener);
        this.label.addMouseListener(this.labelMouseListener);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.label.setMenu(menu);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
            Exception e = new Exception("Warning: setText(null) not permitted--changing to empty string");
            System.err.println(e);
        }
        this.label.setText(text);
    }

    public void setImage(Image image) {
        this.label.setImage(image);
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.label.setToolTipText(text);
    }

    public void setClipping(int clipping) {
        this.clipping = clipping;
        this.redraw();
    }

    public int getClipping() {
        return this.clipping;
    }

    public void setContinued(int continued) {
        this.continued = continued;
    }

    public int getContinued() {
        return this.continued;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBackground(this.SELECTED_BORDER_COLOR);
            this.label.setBackground(this.SELECTED_BACKGROUND_COLOR);
        } else {
            this.setBackground(this.BORDER_COLOR);
            this.label.setBackground(this.BACKGROUND_COLOR);
        }
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.mouseListeners.remove(listener);
    }

    public void setCalendarableItem(CalendarableItem calendarable) {
        this.calendarable = calendarable;
    }

    public CalendarableItem getCalendarableItem() {
        return this.calendarable;
    }
}

