/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.DataSourceConnectionProvider;
import org.eclipse.net4j.internal.db.bundle.OM;
import org.eclipse.net4j.spi.db.DBSchema;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SQL, DBUtil.class);

    private DBUtil() {
    }

    @Deprecated
    public static void sqlDump(Connection conn, String sql) {
        block10: {
            ResultSet rs = null;
            try {
                try {
                    TRACER.format("Dumping output of {0}", new Object[]{sql});
                    rs = conn.createStatement().executeQuery(sql);
                    int numCol = rs.getMetaData().getColumnCount();
                    StringBuilder row = new StringBuilder();
                    int c = 1;
                    while (c <= numCol) {
                        row.append(String.format("%10s | ", rs.getMetaData().getColumnLabel(c)));
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+--");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    while (rs.next()) {
                        row = new StringBuilder();
                        c = 1;
                        while (c <= numCol) {
                            row.append(String.format("%10s | ", rs.getString(c)));
                            ++c;
                        }
                        TRACER.trace(row.toString());
                    }
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+-");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                }
                catch (SQLException sQLException) {
                    DBUtil.close(rs);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                throw throwable;
            }
            DBUtil.close(rs);
        }
    }

    @Deprecated
    public static void sqlDump(IDBConnectionProvider connectionProvider, String sql) {
        Connection connection = connectionProvider.getConnection();
        try {
            DBUtil.sqlDump(connection, sql);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public static IDBSchema createSchema(String name) {
        return new DBSchema(name);
    }

    public static DataSource createDataSource(Map<Object, Object> properties) {
        return DBUtil.createDataSource(properties, null);
    }

    public static DataSource createDataSource(Map<Object, Object> properties, String namespace) {
        return DBUtil.createDataSource(properties, namespace, "class");
    }

    public static DataSource createDataSource(Map<Object, Object> properties, String namespace, String driverClassKey) {
        try {
            return (DataSource)ReflectUtil.instantiate(properties, (String)namespace, (String)driverClassKey, (ClassLoader)OM.class.getClassLoader());
        }
        catch (Exception ex) {
            throw new DBException(ex);
        }
    }

    public static IDBConnectionProvider createConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider(dataSource);
    }

    public static IDBAdapter getDBAdapter(String adapterName) {
        return (IDBAdapter)IDBAdapter.REGISTRY.get((Object)adapterName);
    }

    public static Exception close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                return ex;
            }
        }
        return null;
    }

    public static Exception close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public static Exception close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                Statement statement = resultSet.getStatement();
                if (statement != null) {
                    statement.setMaxRows(0);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            try {
                resultSet.close();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public static List<String> getAllSchemaTableNames(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            return DBUtil.getAllSchemaTableNames(metaData);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static List<String> getAllSchemaTableNames(DatabaseMetaData metaData) {
        ArrayList<String> arrayList;
        ResultSet schemas = null;
        try {
            ArrayList<String> names = new ArrayList<String>();
            schemas = metaData.getSchemas();
            while (schemas.next()) {
                String name = schemas.getString(1);
                names.add(name);
            }
            arrayList = names;
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(schemas);
                throw throwable;
            }
        }
        DBUtil.close(schemas);
        return arrayList;
    }

    public static List<String> getAllTableNames(Connection connection, String dbName) {
        ArrayList<String> arrayList;
        ResultSet tables = null;
        try {
            ArrayList<String> names = new ArrayList<String>();
            DatabaseMetaData metaData = connection.getMetaData();
            if (dbName != null) {
                dbName = dbName.toUpperCase();
                List<String> schemaNames = DBUtil.getAllSchemaTableNames(metaData);
                if (!schemaNames.contains(dbName)) {
                    dbName = null;
                }
            }
            tables = metaData.getTables(null, dbName, null, new String[]{"TABLE"});
            while (tables.next()) {
                String name = tables.getString(3);
                names.add(name);
            }
            arrayList = names;
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(tables);
                throw throwable;
            }
        }
        DBUtil.close(tables);
        return arrayList;
    }

    public static void dropAllTables(Connection connection, String dbName) {
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                for (String tableName : DBUtil.getAllTableNames(connection, dbName)) {
                    String sql = "DROP TABLE " + tableName;
                    DBUtil.trace(sql);
                    statement.execute(sql);
                }
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int selectMinimumInt(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MIN", where);
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number == null) {
            return 0;
        }
        throw new DBException("Not an integer number: " + number);
    }

    public static long selectMinimumLong(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MIN", where);
        if (number instanceof Long) {
            return (Long)number;
        }
        if (number == null) {
            return 0L;
        }
        throw new DBException("Not a long number: " + number);
    }

    public static int selectMaximumInt(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MAX", where);
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number == null) {
            return 0;
        }
        throw new DBException("Not an integer number: " + number);
    }

    public static long selectMaximumLong(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MAX", where);
        if (number instanceof Long) {
            return (Long)number;
        }
        if (number == null) {
            return 0L;
        }
        throw new DBException("Not a long number: " + number);
    }

    /*
     * Exception decompiling
     */
    private static Number getFunctionResult(Connection connection, IDBField field, String function, String ... where) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int update(Connection connection, String sql) {
        DBUtil.trace(sql);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int select(Connection connection, IDBRowHandler rowHandler, String where, IDBField ... fields) throws DBException {
        IDBTable table = fields[0].getTable();
        int i = 1;
        while (i < fields.length) {
            if (fields[i].getTable() != table) {
                throw new IllegalArgumentException("Multiple tables not allowed: " + Arrays.asList(fields));
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        int i2 = 0;
        while (i2 < fields.length) {
            if (i2 > 0) {
                builder.append(", ");
            }
            builder.append(fields[i2]);
            ++i2;
        }
        builder.append(" FROM ");
        builder.append(table);
        if (where != null) {
            builder.append(" WHERE ");
            builder.append(where);
        }
        String sql = DBUtil.trace(builder.toString());
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            statement = connection.createStatement();
            try {
                int rows = 0;
                boolean proceed = true;
                Object[] values = new Object[fields.length];
                resultSet = statement.executeQuery(sql);
                while (proceed && resultSet.next()) {
                    int i3 = 0;
                    while (i3 < fields.length) {
                        long length;
                        values[i3] = resultSet.getObject(i3 + 1);
                        if (values[i3] instanceof Blob) {
                            Blob blob = (Blob)values[i3];
                            length = blob.length();
                            if (length > Integer.MAX_VALUE) {
                                throw new IllegalStateException("byte[] too long: " + length);
                            }
                            values[i3] = blob.getBytes(1L, (int)length);
                        } else if (values[i3] instanceof Clob) {
                            Clob clob = (Clob)values[i3];
                            length = clob.length();
                            if (length > Integer.MAX_VALUE) {
                                throw new IllegalStateException("String too long: " + length);
                            }
                            values[i3] = clob.getSubString(1L, (int)length);
                        }
                        ++i3;
                    }
                    proceed = rowHandler.handle(rows++, values);
                }
                n = rows;
            }
            catch (SQLException ex) {
                try {
                    try {
                        throw new DBException(ex);
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(resultSet);
                        throw throwable;
                    }
                }
                catch (SQLException ex2) {
                    throw new DBException(ex2);
                }
            }
            DBUtil.close(resultSet);
            return n;
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int select(Connection connection, IDBRowHandler rowHandler, IDBField ... fields) throws DBException {
        return DBUtil.select(connection, rowHandler, null, fields);
    }

    public static Object[] select(Connection connection, String where, IDBField ... fields) throws DBException {
        final Object[][] result = new Object[1][];
        IDBRowHandler rowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                result[0] = values;
                return false;
            }
        };
        DBUtil.select(connection, rowHandler, where, fields);
        return result[0];
    }

    public static void serializeTable(ExtendedDataOutput out, Connection connection, IDBTable table, String tableAlias, String sqlSuffix) throws DBException, IOException {
        IDBField[] fields = table.getFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                builder.append(", ");
            }
            if (tableAlias != null) {
                builder.append(tableAlias);
                builder.append(".");
            }
            builder.append(fields[i]);
            ++i;
        }
        builder.append(" FROM ");
        builder.append(table);
        if (tableAlias != null) {
            builder.append(" ");
            builder.append(tableAlias);
        }
        if (sqlSuffix != null) {
            builder.append(sqlSuffix);
        }
        String sql = DBUtil.trace(builder.toString());
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                try {
                    try {
                        resultSet = statement.executeQuery(sql);
                        while (resultSet.next()) {
                            out.writeBoolean(true);
                            int i2 = 0;
                            while (i2 < fields.length) {
                                IDBField field = fields[i2];
                                DBType type = field.getType();
                                boolean canBeNull = !field.isNotNull();
                                type.writeValue(out, resultSet, i2 + 1, canBeNull);
                                ++i2;
                            }
                        }
                        out.writeBoolean(false);
                    }
                    catch (SQLException ex) {
                        throw new DBException(ex);
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    throw throwable;
                }
                DBUtil.close(resultSet);
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static void deserializeTable(ExtendedDataInput in, Connection connection, IDBTable table) throws IOException {
        IDBField[] fields = table.getFields();
        StringBuilder builder = new StringBuilder();
        StringBuilder params = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(table);
        builder.append("(");
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                builder.append(", ");
                params.append(", ");
            }
            builder.append(fields[i]);
            params.append("?");
            ++i;
        }
        builder.append(") VALUES (");
        builder.append(params.toString());
        builder.append(")");
        String sql = DBUtil.trace(builder.toString());
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement(sql);
                while (in.readBoolean()) {
                    int i2 = 0;
                    while (i2 < fields.length) {
                        IDBField field = fields[i2];
                        DBType type = field.getType();
                        boolean canBeNull = !field.isNotNull();
                        type.readValue(in, statement, i2 + 1, canBeNull);
                        ++i2;
                    }
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(statement);
            throw throwable;
        }
        DBUtil.close(statement);
    }

    public static String trace(String sql) {
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        return sql;
    }
}

