/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import org.eclipse.net4j.internal.tcp.TCPAcceptor;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.spi.net4j.AcceptorFactory;

public class TCPAcceptorFactory
extends AcceptorFactory {
    public static final String TYPE = "tcp";
    private static final String SEPARATOR = ":";

    public TCPAcceptorFactory() {
        super(TYPE);
    }

    public TCPAcceptor create(String description) {
        String address = "0.0.0.0";
        int port = ITCPAcceptor.DEFAULT_PORT;
        if (!StringUtil.isEmpty((String)description)) {
            String[] tokens = description.split(SEPARATOR);
            if (!StringUtil.isEmpty((String)tokens[0])) {
                address = tokens[0];
            }
            if (tokens.length > 1 && !StringUtil.isEmpty((String)tokens[1])) {
                port = Integer.parseInt(tokens[1]);
            }
        }
        TCPAcceptor acceptor = new TCPAcceptor();
        acceptor.setAddress(address);
        acceptor.setPort(port);
        return acceptor;
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof TCPAcceptor) {
            TCPAcceptor acceptor = (TCPAcceptor)object;
            return String.valueOf(acceptor.getAddress()) + SEPARATOR + acceptor.getPort();
        }
        return null;
    }
}

