/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.net4j.internal.tcp.TCPClientConnector;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.spi.net4j.ConnectorFactory;

public class TCPConnectorFactory
extends ConnectorFactory {
    public static final String TYPE = "tcp";
    private static final String URL_SCHEME = "http://";

    public TCPConnectorFactory() {
        super(TYPE);
    }

    public TCPClientConnector create(String description) {
        try {
            URL url = new URL(URL_SCHEME + description);
            String userID = url.getUserInfo();
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = ITCPConnector.DEFAULT_PORT;
            }
            TCPClientConnector connector = new TCPClientConnector();
            connector.setUserID(userID);
            connector.setHost(host);
            connector.setPort(port);
            return connector;
        }
        catch (MalformedURLException ex) {
            throw new ProductCreationException((Throwable)ex);
        }
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof TCPClientConnector) {
            int port;
            TCPClientConnector connector = (TCPClientConnector)object;
            String description = connector.getHost();
            String userID = connector.getUserID();
            if (!StringUtil.isEmpty((String)userID)) {
                description = String.valueOf(userID) + "@" + description;
            }
            if ((port = connector.getPort()) != ITCPConnector.DEFAULT_PORT) {
                description = String.valueOf(description) + ":" + port;
            }
            return description;
        }
        return null;
    }
}

