/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.SharedIcons;
import org.eclipse.net4j.util.internal.ui.actions.IntrospectAction;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerNameSorter;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerView
extends ViewPart
implements ISelectionProvider,
ISetSelectionTarget {
    private Shell shell;
    private ContainerItemProvider<IContainer<Object>> itemProvider;
    private TreeViewer viewer;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ITreeSelection selection = (ITreeSelection)event.getSelection();
            IActionBars bars = ContainerView.this.getViewSite().getActionBars();
            ContainerView.this.selectionChanged(bars, selection);
        }
    };
    private Action refreshAction = new RefreshAction();

    public Shell getShell() {
        return this.shell;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void resetInput() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    IContainer<?> container = ContainerView.this.getContainer();
                    ContainerView.this.viewer.setInput(container);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        try {
            Display display = this.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                display.asyncExec(runnable);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    public final void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        Composite composite = UIUtil.createGridComposite(parent, 1);
        Control control = this.createUI(composite);
        control.setLayoutData((Object)UIUtil.createGridData());
        this.hookContextMenu();
        this.hookDoubleClick();
        this.contributeToActionBars();
    }

    protected Control createUI(Composite parent) {
        this.itemProvider = this.createContainerItemProvider();
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider(this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ContainerNameSorter());
        this.resetInput();
        this.viewer.addSelectionChangedListener(this.selectionListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        return this.viewer.getControl();
    }

    protected IContentProvider createContentProvider() {
        return this.itemProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        ILabelDecorator labelDecorator = this.createLabelDecorator();
        return new DecoratingLabelProvider(this.itemProvider, labelDecorator);
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new ContainerItemProvider<IContainer<Object>>(this.getRootElementFilter()){

            @Override
            public Image getImage(Object obj) {
                Image image = ContainerView.this.getElementImage(obj);
                if (image == null) {
                    image = super.getImage(obj);
                }
                return image;
            }

            @Override
            public String getText(Object obj) {
                String text = ContainerView.this.getElementText(obj);
                if (text == null) {
                    text = super.getText(obj);
                }
                return text;
            }

            @Override
            public Color getForeground(Object obj) {
                Color color = ContainerView.this.getElementForeground(obj);
                if (color == null) {
                    color = super.getForeground(obj);
                }
                return color;
            }

            @Override
            public Color getBackground(Object obj) {
                Color color = ContainerView.this.getElementBackground(obj);
                if (color == null) {
                    color = super.getBackground(obj);
                }
                return color;
            }

            @Override
            public Font getFont(Object obj) {
                Font font = ContainerView.this.getElementFont(obj);
                if (font == null) {
                    font = super.getFont(obj);
                }
                return font;
            }
        };
    }

    protected String getElementText(Object element) {
        return null;
    }

    protected Image getElementImage(Object element) {
        return null;
    }

    protected Color getElementForeground(Object element) {
        return null;
    }

    protected Color getElementBackground(Object element) {
        return null;
    }

    protected Font getElementFont(Object element) {
        return null;
    }

    protected IElementFilter getRootElementFilter() {
        return null;
    }

    protected abstract IContainer<?> getContainer();

    protected void hookDoubleClick() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection selection = (ITreeSelection)ContainerView.this.viewer.getSelection();
                Object object = selection.getFirstElement();
                ContainerView.this.doubleClicked(object);
            }
        });
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITreeSelection selection = (ITreeSelection)ContainerView.this.viewer.getSelection();
                ContainerView.this.fillContextMenu(manager, selection);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)new IntrospectAction(this.getViewer()));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        manager.add((IContributionItem)new Separator("additions"));
        this.itemProvider.fillContextMenu(manager, selection);
    }

    protected void selectionChanged(IActionBars bars, ITreeSelection selection) {
    }

    protected void doubleClicked(Object object) {
        if (object != null && this.viewer.isExpandable(object)) {
            if (this.viewer.getExpandedState(object)) {
                this.viewer.collapseToLevel(object, -1);
            } else {
                this.viewer.expandToLevel(object, 1);
            }
        }
    }

    protected void closeView() {
        try {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        ContainerView.this.getSite().getPage().hideView((IViewPart)ContainerView.this);
                        ContainerView.this.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showMessage(String message) {
        this.showMessage(MessageType.INFORMATION, message);
    }

    protected boolean showMessage(MessageType type, String message) {
        switch (type) {
            case INFORMATION: {
                MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case ERROR: {
                MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case WARNING: {
                MessageDialog.openWarning((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case CONFIRM: {
                return MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
            }
            case QUESTION: {
                return MessageDialog.openQuestion((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
            }
        }
        return true;
    }

    protected Display getDisplay() {
        Display display = this.viewer.getControl().getDisplay();
        if (display == null) {
            display = UIUtil.getDisplay();
        }
        return display;
    }

    public void refreshViewer(boolean updateLabels) {
        this.refreshElement(null, updateLabels);
    }

    public void refreshElement(final Object element, final boolean updateLabels) {
        try {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (element != null) {
                            ContainerView.this.viewer.refresh(element, updateLabels);
                        } else {
                            ContainerView.this.viewer.refresh(updateLabels);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void updateLabels(final Object element) {
        try {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ContainerView.this.viewer.update(element, null);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void revealElement(final Object element) {
        try {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ContainerView.this.viewer.reveal(element);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static ImageDescriptor getAddImageDescriptor() {
        return SharedIcons.getDescriptor("etool16/add");
    }

    public static ImageDescriptor getDeleteImageDescriptor() {
        return SharedIcons.getDescriptor("etool16/delete");
    }

    public static ImageDescriptor getRefreshImageDescriptor() {
        return SharedIcons.getDescriptor("etool16/refresh");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Default<CONTAINER extends IContainer<?>>
    extends ContainerView {
        private CONTAINER container;

        protected IListener getContainerListener() {
            return null;
        }

        protected CONTAINER getContainer() {
            return this.container;
        }

        public void setContainer(CONTAINER container) {
            if (this.container != container) {
                IListener containerListener = this.getContainerListener();
                if (containerListener != null && this.container != null) {
                    this.container.removeListener(containerListener);
                }
                this.container = container;
                if (containerListener != null && this.container != null) {
                    this.container.addListener(containerListener);
                }
                this.resetInput();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MessageType {
        INFORMATION,
        ERROR,
        WARNING,
        CONFIRM,
        QUESTION;

    }

    private final class RefreshAction
    extends SafeAction {
        private RefreshAction() {
            super(Messages.getString("ContainerView_1"), Messages.getString("ContainerView_2"), ContainerView.getRefreshImageDescriptor());
        }

        protected void safeRun() throws Exception {
            ContainerView.this.viewer.refresh(false);
        }
    }
}

