/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyBundle
extends AbstractBundle {
    private URL baseURL;

    public LegacyBundle(AbstractPlatform platform, String bundleID, Class<?> accessor) {
        super(platform, bundleID, accessor);
        try {
            this.computeBaseURL(accessor);
            if (this.baseURL == null) {
                throw new IllegalStateException("No base URL");
            }
            this.loadOptions();
        }
        catch (Exception ex) {
            IOUtil.print(ex);
        }
    }

    @Override
    public String getStateLocation() {
        return new File(this.getPlatform().getStateFolder(), ".plugins/" + this.getBundleID()).getAbsolutePath();
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    private void loadOptions() {
        block8: {
            InputStream inputStream = null;
            Properties properties = new Properties();
            try {
                try {
                    String prefix = String.valueOf(this.getBundleID()) + "/";
                    int length = prefix.length();
                    inputStream = this.getInputStream(".options");
                    properties.load(inputStream);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        try {
                            String key = (String)entry.getKey();
                            if (!key.startsWith(prefix)) continue;
                            String value = (String)entry.getValue();
                            this.setDebugOption(key.substring(length), value);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeSilent(inputStream);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent(inputStream);
        }
    }

    private void computeBaseURL(Class<?> accessor) throws MalformedURLException {
        String className = accessor.getName();
        URL url = accessor.getResource(String.valueOf(ReflectUtil.getSimpleName(accessor)) + ".class");
        int segmentsToTrim = 1 + StringUtil.occurrences(className, '.');
        if (LegacyBundle.isArchiveProtocol((url = LegacyBundle.trimSegments(url, segmentsToTrim)).getProtocol())) {
            try {
                InputStream inputStream = new URL(String.valueOf(url.toString()) + "plugin.properties").openStream();
                inputStream.close();
                this.baseURL = url;
            }
            catch (IOException exception) {
                url = LegacyBundle.trimSegments(new URL(url.getFile()), 1);
            }
        }
        if (this.baseURL == null) {
            String lastSegment = LegacyBundle.lastSegment(url);
            if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                url = LegacyBundle.trimSegments(url, 1);
            }
            try {
                InputStream inputStream = new URL(String.valueOf(url.toString()) + "plugin.properties").openStream();
                inputStream.close();
                this.baseURL = url;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.baseURL == null) {
            throw new MissingResourceException("Missing properties: " + accessor.getName(), accessor.getName(), "plugin.properties");
        }
    }

    private static String lastSegment(URL url) {
        int pos;
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (pos = path.lastIndexOf(47)) == -1 ? path : path.substring(pos + 1);
    }

    private static URL trimSegments(URL url, int count) throws MalformedURLException {
        String path = url.getPath();
        if (path.endsWith("/")) {
            ++count;
        }
        int i = 0;
        while (i < count) {
            int pos = path.lastIndexOf(47);
            if (pos == -1) break;
            path = path.substring(0, pos);
            ++i;
        }
        return new URL(String.valueOf(url.getProtocol()) + ":" + path + "/");
    }

    private static boolean isArchiveProtocol(String scheme) {
        return "jar".equalsIgnoreCase(scheme);
    }
}

